#ifndef __CONFIG_H__
#define __CONFIG_H__


#include "types.h"


typedef struct
{
  // video
  char videodriver[520];

  // audio
  int output_driver;  // 0 = none, 1 = DirectSound, 2 = WinMM
  int mixer;
  int bit_rate;
  int stereo;
  int sound_volume;
  int music_volume;

  // input
  int joystick;
  int key_up;
  int key_down;
  int key_left;
  int key_right;
  int key_primary;
  int key_secondary;
  int key_tertiary;
  int key_quaternary;

} SPHERECONFIG;


#include "begin_c_prototypes.h"

  extern bool LoadSphereConfig(SPHERECONFIG* config, const char* filename);
  extern bool SaveSphereConfig(SPHERECONFIG* config, const char* filename);

#include "end_c_prototypes.h"


#endif
