#include "sphere_config.h"
#include "configfile.h"


////////////////////////////////////////////////////////////////////////////////

bool LoadSphereConfig(SPHERECONFIG* config, const char* filename)
{
  // video
  ReadConfigFileString(filename, "Video", "Driver", config->videodriver, 500, "");

  // audio
  ReadConfigFileInt(filename, "Audio", "OutputDriver", &config->output_driver, 1);
  ReadConfigFileInt(filename, "Audio", "Mixer",        &config->mixer,         0);
  ReadConfigFileInt(filename, "Audio", "BitRate",      &config->bit_rate,      22050);
  ReadConfigFileInt(filename, "Audio", "Stereo",       &config->stereo,        true);
  ReadConfigFileInt(filename, "Audio", "SoundVolume",  &config->sound_volume,  255);
  ReadConfigFileInt(filename, "Audio", "MusicVolume",  &config->music_volume,  255);

  // input
  ReadConfigFileInt(filename, "Input", "Joystick",   &config->joystick,       false);
  ReadConfigFileInt(filename, "Input", "Up",         &config->key_up,         38);
  ReadConfigFileInt(filename, "Input", "Down",       &config->key_down,       40);
  ReadConfigFileInt(filename, "Input", "Left",       &config->key_left,       37);
  ReadConfigFileInt(filename, "Input", "Right",      &config->key_right,      39);
  ReadConfigFileInt(filename, "Input", "Primary",    &config->key_primary,    17);
  ReadConfigFileInt(filename, "Input", "Secondary",  &config->key_secondary,  18);
  ReadConfigFileInt(filename, "Input", "Tertiary",   &config->key_tertiary,   9);
  ReadConfigFileInt(filename, "Input", "Quaternary", &config->key_quaternary, 27);

  return true;
}

////////////////////////////////////////////////////////////////////////////////

bool SaveSphereConfig(SPHERECONFIG* config, const char* filename)
{
  // video
  WriteConfigFileString(filename, "Video", "Driver", config->videodriver);

  // audio
  WriteConfigFileInt(filename, "Audio", "OutputDriver", config->output_driver);
  WriteConfigFileInt(filename, "Audio", "Mixer",        config->mixer);
  WriteConfigFileInt(filename, "Audio", "BitRate",      config->bit_rate);
  WriteConfigFileInt(filename, "Audio", "Stereo",       config->stereo);
  WriteConfigFileInt(filename, "Audio", "SoundVolume",  config->sound_volume);
  WriteConfigFileInt(filename, "Audio", "MusicVolume",  config->music_volume);

  // input
  WriteConfigFileInt(filename, "Input", "Joystick",   config->joystick);
  WriteConfigFileInt(filename, "Input", "Up",         config->key_up);
  WriteConfigFileInt(filename, "Input", "Down",       config->key_down);
  WriteConfigFileInt(filename, "Input", "Left",       config->key_left);
  WriteConfigFileInt(filename, "Input", "Right",      config->key_right);
  WriteConfigFileInt(filename, "Input", "Primary",    config->key_primary);
  WriteConfigFileInt(filename, "Input", "Secondary",  config->key_secondary);
  WriteConfigFileInt(filename, "Input", "Tertiary",   config->key_tertiary);
  WriteConfigFileInt(filename, "Input", "Quaternary", config->key_quaternary);

  return true;
}

////////////////////////////////////////////////////////////////////////////////
