#ifndef __INTERNAL_H
#define __INTERNAL_H


#include <windows.h>
#include "sphere_config.h"
#include "../system.h"


#include "begin_c_prototypes.h"

  // graphics.c
  extern bool InitVideo(HWND window, SPHERECONFIG* config);
  extern bool CloseVideo(void);

  // sound.c
  extern bool InitAudio(HWND window, SPHERECONFIG* config);
  extern bool CloseAudio(void);

  // input.c
  extern bool InitInput(HWND window, SPHERECONFIG* config);
  extern bool CloseInput(void);
  extern void OnKeyDown(int virtual_key);
  extern void OnKeyUp(int virtual_key);
  extern void OnMouseMove(int x, int y);
  extern void OnMouseDown(int button);
  extern void OnMouseUp(int button);

#include "end_c_prototypes.h"


#endif
