#ifndef WIN32_FILESYSTEM_H
#define WIN32_FILESYSTEM_H


#include "types.h"


typedef void* DIRECTORYLIST;


#include "begin_c_prototypes.h"

  extern bool MakeDirectory(const char* directory);

  extern bool EnterDirectory(const char* directory);
  extern bool LeaveDirectory(void);

  extern DIRECTORYLIST BeginDirectoryList(const char* mask);
  extern void          EndDirectoryList(DIRECTORYLIST dl);
  extern bool          DirectoryListDone(DIRECTORYLIST dl);
  extern void          GetNextDirectory(DIRECTORYLIST dl, char* directory);

  extern void GetAbsolutePath(char* directory, char* relative_path);
  extern void GetTemporaryDirectory(char* directory);

#include "end_c_prototypes.h"


#endif
