#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include "filesystem.h"


typedef struct
{
  int    numdirectories;
  char** directories;

  int    currentdirectory;
} INTERNAL_DIRECTORYLIST;



static int DirectoryStackSize;
static char** DirectoryStack;


static char OriginalDirectory[520];
static char BaseDirectory[520];


////////////////////////////////////////////////////////////////////////////////

bool MakeDirectory(const char* directory)
{
  return CreateDirectory(directory, NULL);
}

////////////////////////////////////////////////////////////////////////////////

bool EnterDirectory(const char* directory)
{
  char olddirectory[MAX_PATH];

  // get the old directory
  GetCurrentDirectory(MAX_PATH, olddirectory);
  
  // push it on the stack
  DirectoryStack = (char**)realloc(DirectoryStack, sizeof(char*) * (DirectoryStackSize + 1));
  DirectoryStack[DirectoryStackSize] = (char*)malloc(strlen(olddirectory) + 1);
  strcpy(DirectoryStack[DirectoryStackSize], olddirectory);

  DirectoryStackSize++;

  // set the new directory
  if (SetCurrentDirectory(directory))
    return true;
  else
    return false;
}

////////////////////////////////////////////////////////////////////////////////

bool LeaveDirectory(void)
{
  char olddirectory[MAX_PATH];

  // get the previous directory off of the stack
  strcpy(olddirectory, DirectoryStack[DirectoryStackSize - 1]);

  // pop the topmost entry
  DirectoryStackSize--;
  free(DirectoryStack[DirectoryStackSize]);
  DirectoryStack = (char**)realloc(DirectoryStack, sizeof(char*) * DirectoryStackSize);

  // set it
  if (SetCurrentDirectory(olddirectory))
    return true;
  else
    return false;
}

////////////////////////////////////////////////////////////////////////////////

DIRECTORYLIST BeginDirectoryList(const char* mask)
{
  INTERNAL_DIRECTORYLIST* idl = (INTERNAL_DIRECTORYLIST*)malloc(sizeof(INTERNAL_DIRECTORYLIST));
  WIN32_FIND_DATA ffd;
  HANDLE fh;

  // obviously, there are no directories at first
  idl->numdirectories = 0;
  idl->directories = NULL;

  idl->currentdirectory = 0;

  fh = FindFirstFile(mask, &ffd);
  if (fh == INVALID_HANDLE_VALUE)  // if there are no directories, we're done searching
    return idl;

  // build the directory list
  do
  {
    // it has to be a directory and it can't start with a period
    if (ffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY &&
        ffd.cFileName[0] != '.')
    {

      idl->directories = (char**)realloc(idl->directories, (sizeof(char*) * (idl->numdirectories + 1)));
      idl->directories[idl->numdirectories] = (char*)malloc(strlen(ffd.cFileName) + 1);
      strcpy(idl->directories[idl->numdirectories], ffd.cFileName);
      idl->numdirectories++;

    }

  } while (FindNextFile(fh, &ffd));

  FindClose(fh);

  return idl;
}

////////////////////////////////////////////////////////////////////////////////

void EndDirectoryList(DIRECTORYLIST dl)
{
  INTERNAL_DIRECTORYLIST* idl = dl;
  int i;

  for (i = 0; i < idl->numdirectories; i++)
    free(idl->directories[i]);
  free(idl->directories);

  free(dl);
}

////////////////////////////////////////////////////////////////////////////////

bool DirectoryListDone(DIRECTORYLIST dl)
{
  INTERNAL_DIRECTORYLIST* idl = dl;
  return !(idl->currentdirectory < idl->numdirectories);
}

////////////////////////////////////////////////////////////////////////////////

void GetNextDirectory(DIRECTORYLIST dl, char* directory)
{
  INTERNAL_DIRECTORYLIST* idl = dl;
  strcpy(directory, idl->directories[idl->currentdirectory]);
  idl->currentdirectory++;
}

////////////////////////////////////////////////////////////////////////////////

void GetAbsolutePath(char* directory, char* relative_path)
{
  GetCurrentDirectory(MAX_PATH, directory);
  strcat(directory, "\\");
  strcat(directory, relative_path);
}

////////////////////////////////////////////////////////////////////////////////

void GetTemporaryDirectory(char* directory)
{
  int  Length;
  char TempDirLength[MAX_PATH];

  if (directory != NULL)
    free(directory);

  Length = GetTempPath(MAX_PATH, TempDirLength);
  if (Length)
  {
    directory = malloc(Length + 1);
    if (directory == NULL)
      return;

    GetTempPath(Length + 1, directory);
  }
  else
  {
    Length = GetCurrentDirectory(MAX_PATH, TempDirLength);

    // last ditch effort to check if it can't find a directory.
    if (!Length)
      return;

    directory = malloc(Length + strlen("Temp\\") + 1);
    if (directory == NULL)
      return;
    
    GetCurrentDirectory(Length + 1, directory);
    if (!_mkdir("Temp"))
      return;
    
    sprintf(directory + Length, "Temp\\");
  }
}

////////////////////////////////////////////////////////////////////////////////
