#ifndef WIN32_AUDIO_H
#define WIN32_AUDIO_H


#include "types.h"


typedef struct SOUNDEFFECT__ { int dummy__; }* SOUNDEFFECT;
typedef struct MUSICMODULE__ { int dummy__; }* MUSICMODULE;

#define INVALID_SOUNDEFFECT ((SOUNDEFFECT__*)0)
#define INVALID_MUSICMODULE ((MUSICMODULE__*)0)


#include "begin_c_prototypes.h"

  // general
  void SetVolume(int volume);

  // sound effect
  extern SOUNDEFFECT LoadSoundEffect(const char* filename);
  extern bool        DestroySoundEffect(SOUNDEFFECT se);
  extern bool        PlaySoundEffect(SOUNDEFFECT se);
  extern bool        StopSoundEffect(SOUNDEFFECT se);

  extern MUSICMODULE LoadMusicModule(const char* filename);
  extern bool        DestroyMusicModule(MUSICMODULE mm);
  extern bool        StartMusicModule(MUSICMODULE mm);
  extern bool        StopMusicModule(MUSICMODULE mm);

  extern int         GetMusicTime(MUSICMODULE mm);

  extern bool        SetGlobalSoundVolume(int volume);
  extern int         GetGlobalSoundVolume();
  extern bool        SetGlobalMusicVolume(int volume);
  extern int         GetGlobalMusicVolume();
  extern bool        SetSoundVolumeAbsolute(SOUNDEFFECT se, int volume);
  extern bool        SetSoundVolume(SOUNDEFFECT se, int volume);
  extern int         GetSoundVolume(SOUNDEFFECT se);
  extern bool        SetMusicVolume(MUSICMODULE mm, int volume);
  extern int         GetMusicVolume(MUSICMODULE mm);
#include "end_c_prototypes.h"


#endif
