#ifndef VM_INTERFACE_HPP
#define VM_INTERFACE_HPP


#include "colorspace.h"
#include "configfile.h"
#include "video.h"


class CScript;      // #include "script.hpp"
class SFONT;        // #include "sfont.hpp"
class SWINDOWSTYLE; // #include "swindowstyle.hpp"
class SMAP;         // #include "smap.hpp"


struct DATAFILE
{
  char*   filename;
  CONFIG* config;
};


class CVM_Interface
{
public:
  virtual void Exit() = 0;
  virtual void ExitWithMessage(const char* message) = 0;
  virtual bool ShouldExit() = 0;

  virtual void ChangeSong(const char* filename) = 0;
  virtual void PlayEffect(const char* filename) = 0;

  virtual IMAGE LoadImage(const char* filename) = 0;

  virtual void SetFont(const char* filename) = 0;
  virtual SFONT* GetFont() = 0;

  virtual void SetWindowStyle(const char* filename) = 0;
  virtual SWINDOWSTYLE* GetWindowStyle() = 0;

  virtual void AddFrameHook(int update_rate, const char* function) = 0;
  virtual void RemoveFrameHook(const char* function) = 0;
  virtual void MapEngine() = 0;
  virtual void SetMap(const char* filename) = 0;
  virtual SMAP* GetMap() = 0;
  
  virtual void SetColorMask(RGBA mask, int num_frames) = 0;

  virtual void SetDoodadFrame(int frame) = 0;
  virtual void SetDoodadObstructive(bool obstructive) = 0;

  virtual void ClearParty() = 0;
  virtual void AddPartyCharacter(const char* filename) = 0;

  virtual void PlayAnimation(const char* filename) = 0;

  virtual DATAFILE* OpenFile(const char* filename) = 0;
  virtual void CloseFile(DATAFILE* file) = 0;

  virtual void AddMenuItem(const char* item) = 0;
  virtual int ExecuteMenuV(int x, int y, int w, int h, int offset) = 0;
  virtual int ExecuteMenuH(int x, int y, int w, int h, int offset) = 0;
  virtual void SetMenuPointer(const char* filename) = 0;
};


#endif
