#include <stdlib.h>
#include <string.h>
#include "sspriteset.hpp"
#include "../common/Spriteset.hpp"


////////////////////////////////////////////////////////////////////////////////

SSPRITESET::SSPRITESET()
: m_Frames(NULL)
, m_FlipFrames(NULL)
{
}

////////////////////////////////////////////////////////////////////////////////

SSPRITESET::~SSPRITESET()
{
  for (int i = 0; i < m_Spriteset.GetNumDirections(); i++)
  {
    for (int j = 0; j < m_Spriteset.GetNumFrames(i); j++)
    {
      DestroyImage(m_Frames[i][j]);
      DestroyImage(m_FlipFrames[i][j]);
    }
    delete[] m_Frames[i];
    delete[] m_FlipFrames[i];
  }
  delete[] m_Frames;
  delete[] m_FlipFrames;
}

////////////////////////////////////////////////////////////////////////////////

bool
SSPRITESET::Load(const char* filename)
{
  if (!m_Spriteset.Load(filename))
    return false;

  m_Frames = new IMAGE*[m_Spriteset.GetNumDirections()];
  m_FlipFrames = new IMAGE*[m_Spriteset.GetNumDirections()];
  for (int i = 0; i < m_Spriteset.GetNumDirections(); i++)
  {
    m_Frames[i] = new IMAGE[m_Spriteset.GetNumFrames(i)];
    m_FlipFrames[i] = new IMAGE[m_Spriteset.GetNumFrames(i)];
    for (int j = 0; j < m_Spriteset.GetNumFrames(i); j++)
    {
      m_Frames[i][j] = CreateFrameImage(i, j);
      m_FlipFrames[i][j] = CreateFlipFrameImage(i, j);
    }
  }

  return true;
}

////////////////////////////////////////////////////////////////////////////////

const sSpriteset&
SSPRITESET::GetSpriteset() const
{
  return m_Spriteset;
}
 
////////////////////////////////////////////////////////////////////////////////

int
SSPRITESET::GetNumDirections() const
{
  return m_Spriteset.GetNumDirections();
}

////////////////////////////////////////////////////////////////////////////////

int
SSPRITESET::GetNumFrames(int direction) const
{
  return m_Spriteset.GetNumFrames(direction);
}

////////////////////////////////////////////////////////////////////////////////

IMAGE
SSPRITESET::GetFrame(int direction, int frame)
{
  // !!!! modulus should not be needed
  return m_Frames[direction][frame % m_Spriteset.GetNumFrames(direction)];
}

////////////////////////////////////////////////////////////////////////////////

IMAGE
SSPRITESET::GetFlipFrame(int direction, int frame)
{
  return m_FlipFrames[direction][frame];
}

////////////////////////////////////////////////////////////////////////////////

int
SSPRITESET::GetFrameDelay(int direction, int frame) const
{
  return m_Spriteset.GetFrame(direction, frame).GetDelay();
}

////////////////////////////////////////////////////////////////////////////////

IMAGE
SSPRITESET::CreateFrameImage(int direction, int frame)
{
  sSprite& sprite = m_Spriteset.GetFrame(direction, frame);
  return CreateImage(sprite.GetWidth(), sprite.GetHeight(), sprite.GetPixels());
}

////////////////////////////////////////////////////////////////////////////////

IMAGE
SSPRITESET::CreateFlipFrameImage(int direction, int frame)
{
  sSprite sprite = m_Spriteset.GetFrame(direction, frame);
  sprite.FlipVertical();
  return CreateImage(sprite.GetWidth(), sprite.GetHeight(), sprite.GetPixels());
}

////////////////////////////////////////////////////////////////////////////////
