#ifndef __SMAP_HPP
#define __SMAP_HPP


#include "video.h"
#include "../common/Map.hpp"
#include "../common/Layer.hpp"
#include "../common/Tileset.hpp"


class SMAP
{
public:
  SMAP();
  ~SMAP();

  bool Load(const char* filename);
  void InitDelayMap();
  void UpdateAnimations();

  IMAGE GetTileImage(int tile);

  sMap&     GetMap();
  sTileset& GetTileset();

private:
  void CreateMap();
  void DeleteMap();
  void SetMap(const sTileset& tileset);

private:
  sMap  m_Map;
  int** m_DelayMap;    // [layer][y * width + x]

  IMAGE* m_Tiles;
};


#endif
