#ifndef __SFONT_H
#define __SFONT_H


#include "colorspace.h"
#include "../common/Font.hpp"
#include "video.h"


class SFONT
{
public:
  SFONT();
  ~SFONT();

  bool Load(const char* filename);
  bool SetColor(RGBA color);

  bool DrawText(int x, int y, const char* text) const;
  bool DrawTextBox(int x, int y, int w, int h, int offset, const char* text) const;

  int GetMaxHeight() const;
  int GetStringWidth(const char* string) const;

private:
  void Destroy();

private:
  sFont m_Font;

  struct FontColor
  {
    RGBA  color;
    IMAGE images[256];
  }* m_FontColors;
  int m_NumFontColors;

  FontColor* CurrentFontColor;

  int m_MaxWidth;
  int m_MaxHeight;
};


#endif
