#ifndef SCRIPT_SERVER_HPP
#define SCRIPT_SERVER_HPP


#include "vm_interface.hpp"
#include "script.hpp"


class CScriptServer
{
public:
  CScriptServer(CVM_Interface* interface);
  ~CScriptServer();

  CScript* Load(const char* filename);
  void Free(CScript* script);

private:
  struct Script
  {
    sString  name;
    int      refcount;
    CScript* script;
  };

private:
  CVM_Interface* m_Interface;

  sVector<Script> m_Scripts;
};


#endif
