#include <stdio.h>
#include <string.h>
#include "scriptserver.hpp"
#include "x++.hpp"


////////////////////////////////////////////////////////////////////////////////

CScriptServer::CScriptServer(CVM_Interface* interface)
: m_Interface(interface)
{
}

////////////////////////////////////////////////////////////////////////////////

CScriptServer::~CScriptServer()
{
  // m_NumScripts should not be above 0
  while (m_Scripts.size() > 0)
    Free(m_Scripts[0].script);
}

////////////////////////////////////////////////////////////////////////////////

CScript*
CScriptServer::Load(const char* filename)
{
  // if a script is already loaded...
  for (int i = 0; i < m_Scripts.size(); i++)
    if (filename == m_Scripts[i].name)
    {
      m_Scripts[i].refcount++;
      return m_Scripts[i].script;
    }
  
  // we have to load a new one...
  Script script;
  script.name     = filename;
  script.refcount = 1;
  script.script   = new CScript(m_Interface);
  m_Scripts.push_back(script);

  if (!script.script->Load(filename))
  {
    delete script.script;
    m_Scripts.pop_back();
    return NULL;
  }

  // attempt to resolve dependancies
  for (int i = 0; i < script.script->GetNumDependancies(); i++)
  {
    sString filename = script.script->GetDependancyName(i);
    sString path = "scripts/" + filename;

    CScript* d = Load(path.c_str());
    if (d == NULL)
    {
      for (int j = 0; j < i; j++)
        Free(script.script->GetDependancy(j));

      delete script.script;
      m_Scripts.pop_back();
      return NULL;
    }

    script.script->ResolveDependancy(i, d);
  }

  return script.script;
}

////////////////////////////////////////////////////////////////////////////////

void
CScriptServer::Free(CScript* script)
{
  // find the script
  for (int i = 0; i < m_Scripts.size(); i++)
    if (script == m_Scripts[i].script)
      if (--m_Scripts[i].refcount == 0)
      {
        // dereference the dependancies
        for (int j = 0; j < m_Scripts[i].script->GetNumDependancies(); j++)
          Free(m_Scripts[i].script->GetDependancy(j));

        // remove m_Scripts[i]
        delete m_Scripts[i].script;
        m_Scripts.remove(i);

        return;
      }
}

////////////////////////////////////////////////////////////////////////////////
