#ifndef SCRIPT_H
#define SCRIPT_H


#include "vm_interface.hpp"
#include "../common/STypes.hpp"
#include "colorspace.h"


class CScript
{
public:
  CScript(CVM_Interface* vm_interface);
  ~CScript();

  bool Load(const char* filename);
  bool ExecuteFunction(const char* function);

  // dependancies
  int GetNumDependancies();
  const char* GetDependancyName(int i);
  void ResolveDependancy(int i, CScript* script);
  CScript* GetDependancy(int i);

private:
  // internal script->script calls
  bool HasExport(const char* name) const;

  bool ExecuteMangledFunction(const char* function, sdword* retval = NULL, int stacksize = 0, sdword* stack = NULL, int parameter_level = 0);
  void ExecuteSystemFunction(int ordinal);
  
  sdword* GrabParameter(dword*& location, sdword* spare);
  int GetNumParameters(dword ordinal);

private:
  struct ExecutionContext
  {
    sdword registers[8];  // r0-r7

    int     stacksize;
    sdword* stack;
    int     parameter_level;

    int      num_locals;
    sdword*  locals;

    // variables used in the VM system calls
    int frame_rate;
    bool should_render;
    dword frames_skipped;

    dword ideal_time;

    RGBA CurrentPenColor;
    RGBA CurrentBrushColor;
  };

private:
  CVM_Interface* VM_Interface;

  int       num_dependancies;
  char**    dependancy_names;
  CScript** dependancies;

  int    numlabels;
  char** labels;
  dword* labeloffsets;
  dword* code;

  sStack<ExecutionContext> contexts;
};



#endif
