#ifndef RENDER_SORT_HPP
#define RENDER_SORT_HPP


#include "video.h"


// needed for qsort()
#ifndef CDECL
#ifdef _WIN32
#define CDECL __cdecl
#else
#define CDECL
#endif
#endif


class CRenderSort
{
public:
  CRenderSort();
  ~CRenderSort();

  void AddObject(int base_x, int base_y, int offset_x, int offset_y, IMAGE image);
  void DrawObjects();

private:
  struct Object
  {
    int   base_x;
    int   base_y;
    int   offset_x;
    int   offset_y;
    IMAGE image;
  };

private:
  static int CDECL compare_objects(const void* a, const void* b);

  int     m_allocated;
  int     m_size;
  Object* m_objects;
};


#endif
