#include "rendersort.hpp"


////////////////////////////////////////////////////////////////////////////////

CRenderSort::CRenderSort()
: m_allocated(64)
, m_size(0)
, m_objects(new Object[64])
{
}

////////////////////////////////////////////////////////////////////////////////

CRenderSort::~CRenderSort()
{
  realloc(m_objects, 0);
}

////////////////////////////////////////////////////////////////////////////////

void
CRenderSort::AddObject(int base_x, int base_y, int offset_x, int offset_y, IMAGE image)
{
  m_objects[m_size].base_x   = base_x;
  m_objects[m_size].base_y   = base_y;
  m_objects[m_size].offset_x = offset_x;
  m_objects[m_size].offset_y = offset_y;
  m_objects[m_size].image    = image;

  m_size++;
  if (m_size >= m_allocated)
  {
    m_objects = (Object*)realloc(m_objects, (m_allocated + 64) * sizeof(Object));
    m_allocated += 64;
  }
}

////////////////////////////////////////////////////////////////////////////////

void
CRenderSort::DrawObjects()
{
  // sort the object list
  qsort(m_objects, m_size, sizeof(Object), compare_objects);

  // draw images to screen
  for (int i = 0; i < m_size; i++) {
    Object* o = m_objects + i;
    BlitImage(o->image, o->base_x - o->offset_x, o->base_y - o->offset_y);
  }

  // reset the list
  m_size = 0;
}

////////////////////////////////////////////////////////////////////////////////

int CDECL
CRenderSort::compare_objects(const void* a, const void* b)
{
  const Object* c = (const Object*)a;
  const Object* d = (const Object*)b;
  return (c->base_y - d->base_y);
}

////////////////////////////////////////////////////////////////////////////////
