#include <stdio.h>
#include <stdlib.h>
#include "render.h"
#include "colorspace.h"
#include "video.h"
#include "timer.h"



////////////////////////////////////////////////////////////////////////////////

void ClearScreen(void)
{
  ApplyColorMask(rgbaBlack);
}

////////////////////////////////////////////////////////////////////////////////

void FadeIn(unsigned msecs)
{
  IMAGE image = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

  RGBA black = { 0, 0, 0, 0 };
  dword time = GetTime();
  while (GetTime() - time < msecs)
  {
    black.alpha = 255 - (byte)((GetTime() - time) * 255 / msecs);
    BlitImage(image, 0, 0);
    ApplyColorMask(black);
    FlipScreen();
  }

  DestroyImage(image);
}

////////////////////////////////////////////////////////////////////////////////

void FadeOut(unsigned msecs)
{
  IMAGE image = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

  RGBA black = { 0, 0, 0, 0 };
  dword time = GetTime();
  while (GetTime() - time < msecs)
  {
    black.alpha = (byte)((GetTime() - time) * 255 / msecs);
    BlitImage(image, 0, 0);
    ApplyColorMask(black);
    FlipScreen();
  }

  DestroyImage(image);
}

////////////////////////////////////////////////////////////////////////////////
