#include <stdlib.h>
#include "menu.hpp"
#include "sfont.hpp"
#include "swindowstyle.hpp"
#include "video.h"
#include "input.h"
#include "inputx.h"
#include "x++.hpp"


////////////////////////////////////////////////////////////////////////////////

sMenu::sMenu()
: num_menu_items(0)
, menu_items(NULL)
{
}

////////////////////////////////////////////////////////////////////////////////

sMenu::~sMenu()
{
  Clear();
}

////////////////////////////////////////////////////////////////////////////////

void
sMenu::AddItem(const char* item)
{
  menu_items = (char**)realloc(menu_items, (num_menu_items + 1) * sizeof(char*));
  menu_items[num_menu_items] = newstr(item);
  num_menu_items++;
}

////////////////////////////////////////////////////////////////////////////////

void
sMenu::Clear()
{
  for (int i = 0; i < num_menu_items; i++)
    delete[] menu_items[i];
  realloc(menu_items, 0);
  menu_items = NULL;
  num_menu_items = 0;
}

////////////////////////////////////////////////////////////////////////////////

int
sMenu::ExecuteV(MENUDISPLAYDATA& mdd, int x, int y, int w, int h, int offset)
{
  ClearKeyQueue();

  IMAGE background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

  int text_height = mdd.font->GetMaxHeight();
  int displayed_menu_items = h / offset;

  int selection = 0;
  int top_selection = 0;

  bool done = false;
  while (!done)
  {
    // draw the background
    BlitImage(background, 0, 0);

    // draw the window
    mdd.window_style->DrawWindow(x, y, w, h);

    // draw the menu items
    for (int i = 0; i < displayed_menu_items; i++)
      if (i < num_menu_items)
        mdd.font->DrawText(x + 16, y + i * offset, menu_items[i + top_selection]);

    // draw the selection arrow
    BlitImage(mdd.arrow, x, y + (selection - top_selection) * offset);

    // draw the up and down arrows if necessary
    if (top_selection > 0)
      BlitImage(mdd.up_arrow, x + w - GetImageWidth(mdd.up_arrow), y);
    if (top_selection + displayed_menu_items < num_menu_items)
      BlitImage(mdd.down_arrow, x + w - GetImageWidth(mdd.down_arrow), y + offset * displayed_menu_items - GetImageHeight(mdd.down_arrow));

    FlipScreen();

    // handle keypresses
    while (KeysLeft())
    {
      switch (GetKey())
      {
        case KEY_ENTER:
          done = true;
          break;

        case KEY_ESCAPE:
          selection = -1;
          done = true;
          break;

        case KEY_DOWN:
          if (selection < num_menu_items - 1)
          {
            selection++;
            if (selection >= top_selection + displayed_menu_items)
              top_selection++;
          }
          break;

        case KEY_UP:
          if (selection > 0)
          {
            selection--;
            if (selection < top_selection)
              top_selection--;
          }
          break;
      }
    } // end handle input
  }

  DestroyImage(background);
  return selection;
}

////////////////////////////////////////////////////////////////////////////////

int
sMenu::ExecuteH(MENUDISPLAYDATA& mdd, int x, int y, int w, int h, int offset)
{
  ClearKeyQueue();

  IMAGE background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

  int displayed_menu_items = w / offset;

  int selection = 0;
  int top_selection = 0;

  bool done = false;
  while (!done)
  {
    // draw the background
    BlitImage(background, 0, 0);

    // draw the window
    mdd.window_style->DrawWindow(x, y, w, h);

    // draw the menu items
    for (int i = 0; i < displayed_menu_items; i++)
      if (i < num_menu_items)
        mdd.font->DrawText(x + 16 + i * offset, y, menu_items[i + top_selection]);

    // draw the selection arrow
    BlitImage(mdd.arrow, x + (selection - top_selection) * offset, y);

/*
    // draw the up and down arrows if necessary
    if (top_selection > 0)
      BlitImage(mdd.up_arrow, x + w - GetImageWidth(mdd.up_arrow), y);
    if (top_selection + displayed_menu_items < num_menu_items)
      BlitImage(mdd.down_arrow, x + w - GetImageWidth(mdd.down_arrow), y + offset * displayed_menu_items - GetImageHeight(mdd.down_arrow));
*/

    FlipScreen();

    // handle keypresses
    while (KeysLeft())
    {
      switch (GetKey())
      {
        case KEY_ENTER:
          done = true;
          break;

        case KEY_ESCAPE:
          selection = -1;
          done = true;
          break;

        case KEY_RIGHT:
          if (selection < num_menu_items - 1)
          {
            selection++;
            if (selection >= top_selection + displayed_menu_items)
              top_selection++;
          }
          break;

        case KEY_LEFT:
          if (selection > 0)
          {
            selection--;
            if (selection < top_selection)
              top_selection--;
          }
          break;
      }
    } // end handle input
  }

  DestroyImage(background);
  return selection;
}

////////////////////////////////////////////////////////////////////////////////
