#ifndef TILESET_VIEW_HPP
#define TILESET_VIEW_HPP


#include <afxwin.h>
#include <afxext.h>
#include "DIBSection.hpp"
#include "../common/Tileset.hpp"


class CTilesetViewHandler
{
public:
  virtual void TV_SelectedTileChanged(int tile) = 0;
  virtual void TV_TilesetChanged() = 0;
};


class CTilesetView : public CWnd
{
public:
  CTilesetView();
  ~CTilesetView();

  BOOL Create(CStatusBar* status_bar, CTilesetViewHandler* handler, CWnd* parent, sTileset* tileset);

  void TileChanged(int tile);
  void TilesetChanged();

  void SetSelectedTile(int tile);
  int  GetSelectedTile() const;

private:
  int GetPageSize();
  int GetNumRows();
  void UpdateScrollBar();

  afx_msg void OnPaint();
  afx_msg void OnSize(UINT type, int cx, int cy);
  afx_msg void OnVScroll(UINT code, UINT pos, CScrollBar* scroll_bar);
  afx_msg void OnLButtonDown(UINT flags, CPoint point);
  afx_msg void OnMouseMove(UINT flags, CPoint point);
  afx_msg void OnRButtonUp(UINT flags, CPoint point);

  afx_msg void OnInsertTile();
  afx_msg void OnAppendTile();
  afx_msg void OnDeleteTile();
  afx_msg void OnTileProperties();
  afx_msg void OnInsertTiles();
  afx_msg void OnAppendTiles();
  afx_msg void OnDeleteTiles();

private:
  CStatusBar* m_StatusBar;
  CTilesetViewHandler* m_Handler;

  sTileset* m_Tileset;

  int m_TopRow;
  int m_SelectedTile;

  CDIBSection* m_BlitTile;

  bool m_MenuShown;

  DECLARE_MESSAGE_MAP()
};


#endif
