#ifndef TILESET_EDIT_VIEW_HPP
#define TILESET_EDIT_VIEW_HPP


#include <afxwin.h>
#include "ImageView.hpp"
#include "PaletteView.hpp"
#include "ColorView.hpp"
#include "AlphaView.hpp"
#include "SwatchPalette.hpp"
#include "../common/Tileset.hpp"


class CTilesetEditViewHandler
{
public:
  virtual void TEV_SelectedTileChanged(int tile) = 0;
  virtual void TEV_TileModified(int tile) = 0;
  virtual void TEV_TilesetModified() = 0;
};


class CTilesetEditView
  : public CWnd
  , private CImageViewHandler
  , private CPaletteViewHandler
  , private CColorViewHandler
  , private CAlphaViewHandler
{
public:
  CTilesetEditView();
  ~CTilesetEditView();

  BOOL Create(CWnd* parent, CSwatchPalette* swatchpalette, CTilesetEditViewHandler* handler, sTileset* tileset);

  void TilesetChanged();

  void SelectTile(int tile);

  void SP_ColorSelected(RGBA color);

private:
  void UpdateImageView();

  void InitButtonBar();
  void MoveButtonBar(int x, int y, int w, int h);
  void CloseButtonBar();

  void UpdateScrollBar();

  afx_msg void OnSize(UINT type, int cx, int cy);
  afx_msg void OnHScroll(UINT uSBCode, UINT uPos, CScrollBar* pScrollBar);
  afx_msg void OnTimer(UINT timer);

  afx_msg void OnTilesetFill();
  afx_msg void OnTilesetFillAlpha();
  afx_msg void OnTilesetCopy();
  afx_msg void OnTilesetPaste();
  afx_msg void OnTilesetTileProperties();

  afx_msg void OnTilesetUndo();
  afx_msg void OnTilesetRotateCW();
  afx_msg void OnTilesetRotateCCW();
  afx_msg void OnTilesetFlipHorizontal();
  afx_msg void OnTilesetFlipVertical();

  afx_msg void OnTilesetInsertTiles();
  afx_msg void OnTilesetAppendTiles();

  afx_msg void OnUpdateTilesetDeleteTile(CCmdUI* cmdui);
  afx_msg void OnTilesetDeleteTile();

  afx_msg void OnTilesetReplaceWithImage();
  afx_msg void OnTilesetInsertImage();
  afx_msg void OnTilesetAppendImage();

  virtual void IV_ImageChanged();
  virtual void IV_ColorChanged(RGBA color);
  virtual void PV_ColorChanged(RGB color);
  virtual void CV_ColorChanged(RGB color);
  virtual void AV_AlphaChanged(byte alpha);

private:
  CTilesetEditViewHandler* m_Handler;
  sTileset* m_Tileset;

  int   m_CurrentTile;
  sTile m_UndoTile;

  bool m_Created;

  // views
  CImageView   m_ImageView;
  CPaletteView m_PaletteView;
  CColorView   m_ColorView;
  CAlphaView   m_AlphaView;

  // palette
  CSwatchPalette* m_SwatchPalette;

  // button bar
  CButton m_FillButton;
  CButton m_FillAlphaButton;
  CButton m_CopyButton;
  CButton m_PasteButton;
  CButton m_PropertiesButton;
  CButton m_UndoButton;
  CButton m_RotateCWButton;
  CButton m_RotateCCWButton;
  CButton m_FlipHorizButton;
  CButton m_FlipVertButton;

  DECLARE_MESSAGE_MAP()
};


#endif
