#ifndef TILE_PREVIEW_PALETTE_HPP
#define TILE_PREVIEW_PALETTE_HPP


#include <afxwin.h>
#include "../common/Tileset.hpp"
#include "DIBSection.hpp"


class CTilePreviewPalette : public CMiniFrameWnd
{
public:
  CTilePreviewPalette(CWnd* parent, sTileset* tileset);
  ~CTilePreviewPalette();

  void SetTile(int tile);

private:
  afx_msg void OnPlay();
  afx_msg void OnStop();
  afx_msg void OnClose();
  afx_msg void OnSize(UINT type, int cx, int cy);
  afx_msg void OnPaint();
  afx_msg void OnTimer(UINT nIDEvent);

private:
  bool         m_Created;
  int          m_AspectRatio;

  CButton      m_PlayButton;
  CButton      m_StopButton;
  CDIBSection* m_DrawBitmap;

  sTileset*    m_Tileset;
  int          m_TileNum;
  int          m_AnimTileNum;
  int          m_TileDelay;
  int          m_DelayCounter;

  DECLARE_MESSAGE_MAP()
};


#endif
