#ifndef TILE_OBSTRUCTION_VIEW_HPP
#define TILE_OBSTRUCTION_VIEW_HPP


#include "ScrollWindow.hpp"
#include "DIBSection.hpp"


class sTile;  // #include "../common/Tile.hpp"


enum
{
  TOV_PRESET_UNBLOCKED,
  TOV_PRESET_BLOCKED,
  TOV_PRESET_UPPERRIGHT,
  TOV_PRESET_LOWERRIGHT,
  TOV_PRESET_LOWERLEFT,
  TOV_PRESET_UPPERLEFT,
};


class CTileObstructionView : public CScrollWindow
{
public:
  CTileObstructionView();
  ~CTileObstructionView();

  BOOL Create(sTile* tile, CWnd* parent);
  void SetDrawMode(bool pen_down);
  void Preset(int preset);

private:
  void PresetUnblocked();
  void PresetBlocked();
  void PresetUpperRight();
  void PresetLowerRight();
  void PresetLowerLeft();
  void PresetUpperLeft();

  void UpdateScrollBars();
  void Click(int x, int y);

  afx_msg void OnSize(UINT type, int cx, int cy);
  afx_msg void OnPaint();

  afx_msg void OnLButtonDown(UINT flags, CPoint point);
  afx_msg void OnLButtonUp(UINT flags, CPoint point);
  afx_msg void OnMouseMove(UINT flags, CPoint point);

  void OnHScrollChanged(int x);
  void OnVScrollChanged(int y);

private:
  sTile* m_Tile;

  CDIBSection m_RenderPixel;

  bool m_PenDown;
  
  int  m_ScrollX;
  int  m_ScrollY;
  bool m_Clicked;

  DECLARE_MESSAGE_MAP()
};


#endif
