#ifndef T_HPP
#define T_HPP


#include <afxwin.h>
#include "../common/Spriteset.hpp"
#include "DIBSection.hpp"


class CSpritePreviewPalette : public CMiniFrameWnd
{
public:
  CSpritePreviewPalette(CWnd* parent, sSpriteset* spriteset);
  ~CSpritePreviewPalette();

  void SetDirection(int direction);

private:
  afx_msg void OnPlay();
  afx_msg void OnStop();
  afx_msg void OnClose();
  afx_msg void OnSize(UINT type, int cx, int cy);
  afx_msg void OnPaint();
  afx_msg void OnTimer(UINT nIDEvent);

private:
  bool         m_Created;
  int          m_AspectRatio;

  CButton      m_PlayButton;
  CButton      m_StopButton;
  CDIBSection* m_DrawBitmap;

  sSpriteset*  m_Spriteset;
  int          m_Direction;
  int          m_FrameNum;
  int          m_FrameDelay;
  int          m_DelayCounter;

  DECLARE_MESSAGE_MAP()
};


#endif
