#ifndef SOUND_WINDOW_HPP
#define SOUND_WINDOW_HPP


#include "DocumentWindow.hpp"
#include "MusicWindow.hpp"
#include "Audio.hpp"


class CSoundWindow : public CDocumentWindow
{
public:
  CSoundWindow(const char* sound);
  ~CSoundWindow();

private:
  afx_msg void OnSize(UINT type, int cx, int cy);
  afx_msg void OnTimer(UINT timerID);
  afx_msg void OnVScroll(UINT code, UINT pos, CScrollBar *scroll_bar);

  afx_msg void OnSoundPlay();
  afx_msg void OnSoundStop();

private:
  CSample m_Sample;
  CButton m_PlayButton;
  CButton m_StopButton;

  CMusicTrack m_VolumeBar;
  CStatic m_VolumeBarGraphic;
  CBitmap m_VolumeBarBitmap;
  CStatic m_Blank;

  DECLARE_MESSAGE_MAP()
};


#endif
