/////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1998 by Juraj Rojko jrojko@twist.cz
// All rights reserved
//
// VBScriptEditorView.h : interface of the CVBScriptEditorView class
//
/////////////////////////////////////////////////////////////////////////////

/* 
   19th April 2000
   Code cleaned up and modified by Darklich for use with SDE 
   (Sphere Development Environment)
*/


#ifndef SCRIPT_VIEW_HPP
#define SCRIPT_VIEW_HPP


#include <afxwin.h>
#include <afxcmn.h>
#include <afxext.h>


class CScriptViewHandler
{
public:
  virtual void SV_ScriptChanged() = 0;
};


class CScriptView : public CRichEditCtrl
{
public:
  CScriptView();
  ~CScriptView();
  
  BOOL Create(CStatusBar* status_bar, CScriptViewHandler* pHandler, CWnd* pParentWindow);
  void FormatAll();

  void ScriptFindWord();
  void ScriptFindReplaceWord();

private:
  afx_msg void OnSetFocus(CWnd *pOldWnd);
  afx_msg void OnKeyUp(UINT nKey, UINT nRepCnt, UINT nFlags);
  afx_msg void OnKeyDown(UINT nKey, UINT nRepCnt, UINT nFlags);
  afx_msg void OnChar(UINT nKey, UINT nRepCnt, UINT nFlags);
  afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
  LRESULT OnFindReplaceMsg(WPARAM wParam, LPARAM lParam);

  void UpdateLineInfo();
  void OnChange();
  void SetFormatRange(int nStart, int nEnd, BOOL bBold, COLORREF clr);
  void FormatTextLines(int nLineStart, int nLineEnd);
  void FormatTextRange(int nStart, int nEnd);

  void OnFindText();
  void OnReplaceText();
  void OnReplaceAll();

private:
  struct SymbolColor
  {
    bool     bold;
    COLORREF color;
  };
  enum ChangeType { ctUndo, ctUnknown, ctReplSel, ctBack, ctDelete, ctCut, ctPaste, ctMove };

private:
  CFindReplaceDialog* m_SearchDialog;
  CScriptViewHandler* m_Handler;
  CStatusBar*      m_StatusBar;
  ChangeType      m_ChangeType;
	
  static SymbolColor m_icComment;
  static SymbolColor m_icNumber;
  static SymbolColor m_icString;
  static SymbolColor m_icKeyword;
  static SymbolColor m_icFunction;

  CHARRANGE m_OldSel;

  bool m_InForcedChange;
  bool m_ControlPressed;
  bool m_ShiftPressed;
  bool m_NumlockPressed;
  bool m_FindReplaceDialogCreated;

  long m_LineCount;

  DECLARE_MESSAGE_MAP()
};


#endif
