#ifndef __PROJECTWINDOW_HPP
#define __PROJECTWINDOW_HPP


#include <afxwin.h>
#include <afxcmn.h>


class CMainWindow; // MainWindow.hpp
class CProject;    // Project.hpp


class CProjectWindow : public CMDIChildWnd
{
public:
  CProjectWindow(CMainWindow* main_window, CProject* project);
  
  BOOL Create();
  BOOL DestroyWindow();

  void Update();

private:
  afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
  afx_msg void OnSize(UINT type, int cx, int cy);
  afx_msg void OnSetFocus(CWnd* pOldWindow);

  afx_msg void OnProjectGroupInsert();

  afx_msg void OnProjectItemOpen();
  afx_msg void OnProjectItemDelete();
  afx_msg void OnProjectItemCompile();

  afx_msg void OnKeyDown(NMHDR* notify, LRESULT* result);
  afx_msg void OnDoubleClick(NMHDR* notify, LRESULT* result);
  afx_msg void OnRightClick(NMHDR* notify, LRESULT* result);

  void SelectItemAtCursor();

private:
  CMainWindow* m_MainWindow;
  CProject*    m_Project;

  CTreeCtrl m_TreeControl;

  DECLARE_MESSAGE_MAP()
};


#endif
