#ifndef PROJECT_HPP
#define PROJECT_HPP


enum EGroupType
{
  GT_MAPS         = 0,
  GT_SPRITESETS   = 1,
  GT_SCRIPTS      = 2,
  GT_SOUNDS       = 3,
  GT_MUSIC        = 4,
  GT_FONTS        = 5,
  GT_WINDOWSTYLES = 6,
  GT_IMAGES       = 7,
  GT_ANIMATIONS   = 8,

  NUM_GROUP_TYPES = 9,
};


class CProject
{
public:
  CProject();
  ~CProject();

  bool Create(const char* games_directory, const char* project_name);
  bool Open(const char* filename);
  bool Save() const;

  const char* GetDirectory() const;        // returns full path to game
  const char* GetGameSubDirectory() const;

  const char* GetGameTitle() const;
  const char* GetGameScript() const;
  int         GetScreenWidth() const;
  int         GetScreenHeight() const;

  void SetGameTitle(const char* game_title);
  void SetGameScript(const char* game_script);
  void SetScreenWidth(int width);
  void SetScreenHeight(int height);

  static const char* GetGroupDirectory(int grouptype); // returns relative path

  void RefreshItems();

  int         GetItemCount(EGroupType grouptype) const;
  const char* GetItem(EGroupType grouptype, int index) const;
  bool        HasItem(EGroupType grouptype, const char* item) const;

private:
  struct Group
  {
    int    num_entries;
    char** entries;
  };

private:
  void AddItem(int grouptype, const char* filename);
  void Destroy();

private:
  char* m_Directory;
  char* m_Filename;

  char* m_GameTitle;
  char* m_GameScript;

  int m_ScreenWidth;
  int m_ScreenHeight;

  Group m_Groups[NUM_GROUP_TYPES];
};


#endif
