#include "NumberDialog.hpp"
#include "x++.hpp"
#include "resource.h"


////////////////////////////////////////////////////////////////////////////////

CNumberDialog::CNumberDialog(const char* szTitle, const char* szText, int iValue, int iMin, int iMax)
: CDialog(IDD_NUMBER)
, m_szTitle(newstr(szTitle))
, m_szText(newstr(szText))

, m_iValue(iValue)

, m_iMin(iMin)
, m_iMax(iMax)
{
}

////////////////////////////////////////////////////////////////////////////////

CNumberDialog::~CNumberDialog()
{
  delete[] m_szTitle;
  delete[] m_szText;
}

////////////////////////////////////////////////////////////////////////////////

int
CNumberDialog::GetValue() const
{
  return m_iValue;
}

////////////////////////////////////////////////////////////////////////////////

afx_msg BOOL
CNumberDialog::OnInitDialog()
{
  CDialog::OnInitDialog();

  // get pointers to all dialog controls
  m_pStatic = (CStatic*)GetDlgItem(IDC_NUMBERTEXT);
  m_pNumberEdit = (CEdit*)GetDlgItem(IDC_NUMBER);

  // initialize the dialog box
  SetWindowText(m_szTitle);
  m_pStatic->SetWindowText(m_szText);

  m_pNumberEdit->SetFocus();

  char szNumber[80];
  sprintf(szNumber, "%d", m_iValue);
  m_pNumberEdit->SetWindowText(szNumber);

  m_pNumberEdit->SetSel(0, -1);

  return FALSE;
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CNumberDialog::OnOK()
{
  CString text;
  m_pNumberEdit->GetWindowText(text);
  int iValue = atoi(text);

  if (iValue < m_iMin || iValue > m_iMax)
  {
    char string[80];
    sprintf(string, "Value must be between %d and %d", m_iMin, m_iMax);
    MessageBox(string, m_szTitle);
  }  
  else
  {
    m_iValue = iValue;
    CDialog::OnOK();
  }
}

////////////////////////////////////////////////////////////////////////////////
