#include "MusicWindow.hpp"
#include "resource.h"


#define ID_MUSIC_TRACKBAR  40101
#define ID_MUSIC_VOLUMEBAR 40102


const int TIMER_UPDATE_MUSIC_WINDOW = 832;


BEGIN_MESSAGE_MAP(CMusicTrack, CSliderCtrl)
  ON_WM_LBUTTONDOWN()
  ON_WM_LBUTTONUP()
END_MESSAGE_MAP()


BEGIN_MESSAGE_MAP(CMusicWindow, CDocumentWindow)

  ON_WM_CLOSE()
  ON_WM_SIZE()
  ON_WM_TIMER()
  ON_WM_HSCROLL()
  ON_WM_VSCROLL()

  ON_COMMAND(ID_MUSIC_PLAY, OnMusicPlay)
  ON_COMMAND(ID_MUSIC_STOP, OnMusicStop)

END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////////

CMusicTrack::CMusicTrack()
: MouseDown(false)
{
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CMusicTrack::OnLButtonDown(UINT flags, CPoint point)
{
  MouseDown = true;
  CSliderCtrl::OnLButtonDown(flags, point);
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CMusicTrack::OnLButtonUp(UINT flags, CPoint point)
{
  MouseDown = false;
  CSliderCtrl::OnLButtonUp(flags, point);
}

////////////////////////////////////////////////////////////////////////////////

CMusicWindow::CMusicWindow(const char* music)
: CDocumentWindow(music, IDR_MUSIC, CSize(250, 120))
{
  // load the song
  if (!m_Module.Load(music))
  {
    // if it fails, show a message box and close the window
    AfxGetApp()->m_pMainWnd->MessageBox("Could not load music file");
    delete this;
    return;
  }


  // create the window
  Create(AfxRegisterWndClass(0, NULL, NULL, AfxGetApp()->LoadIcon(IDI_MUSIC)));
    
  // load the font
  CFont* pFont = CFont::FromHandle((HFONT)GetStockObject(DEFAULT_GUI_FONT));
  
  // create the buttons
  m_PlayButton.Create("Play", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, CRect(), this, ID_MUSIC_PLAY);
  m_PlayButton.SetFont(pFont);
  m_StopButton.Create("Stop", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, CRect(), this, ID_MUSIC_STOP);
  m_StopButton.SetFont(pFont);
  
  //Create the remaining stuff, the trackbars and the graphic "Volume Bar"
  m_VolumeBar.Create(WS_CHILD | WS_VISIBLE | TBS_VERT, CRect(), this, ID_MUSIC_VOLUMEBAR);
  m_VolumeBar.SetLineSize(20);
  m_VolumeBar.SetRange(0, 65535, true);
  m_VolumeBarBitmap.LoadBitmap(IDB_VOLUMEBAR);
  m_VolumeBarGraphic.Create(NULL, WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | SS_BITMAP, CRect(), this);
  m_VolumeBarGraphic.SetBitmap((HBITMAP)m_VolumeBarBitmap);
  m_Blank.Create(NULL, WS_CHILD | WS_VISIBLE, CRect(), this);
  //m_MusicTrackBar.Create(WS_CHILD | WS_VISIBLE | TBS_HORZ | TBS_NOTICKS | TBS_BOTH | WS_DISABLED, CRect(), this, ID_MUSIC_TRACKBAR);
  m_MusicTrackBar.Create(WS_CHILD | WS_VISIBLE | TBS_HORZ | TBS_BOTH | TBS_NOTICKS, CRect(), this, ID_MUSIC_TRACKBAR);
  m_MusicTrackBar.SetLineSize(12);
  m_MusicTrackBar.SetRange(0, 1, true); //just in case something dumb occurs
  m_MusicTrackBar.SetRange(0, m_Module.GetSongLength(), true);


  // make sure the buttons are in the right position
  RECT Rect;
  GetClientRect(&Rect);
  OnSize(0, Rect.right - Rect.left, Rect.bottom - Rect.top);

  m_VolumeBar.SetPos(65535 - m_Module.GetVolume());
  
  if (m_Module.m_MusicType == MUSIC_MOD)
  {
    SetWindowText(m_Module.ModuleGetSongName());
    //m_MusicTrackBar.EnableWindow(false);
  }
  m_StopButton.EnableWindow(false);

  SetTimer(TIMER_UPDATE_MUSIC_WINDOW, 100, NULL);
  OnTimer(TIMER_UPDATE_MUSIC_WINDOW);
}

////////////////////////////////////////////////////////////////////////////////

CMusicWindow::~CMusicWindow()
{
  m_VolumeBarBitmap.DeleteObject();
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CMusicWindow::OnClose()
{
  m_Module.Stop();

  CDocumentWindow::OnClose();
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CMusicWindow::OnSize(UINT type, int cx, int cy)
{
  if (m_PlayButton.m_hWnd != NULL)
    m_PlayButton.MoveWindow(CRect(0, 0, (cx-50)/2, cy-30));

  if (m_StopButton.m_hWnd != NULL)
    m_StopButton.MoveWindow(CRect((cx-50)/2, 0, cx-50, cy-30));

  //gah, this bit sucks...
  if (m_VolumeBar.m_hWnd != NULL)
    m_VolumeBar.MoveWindow(CRect(cx-50, 0, cx-30, 90));

  if (m_VolumeBarGraphic.m_hWnd != NULL)
    m_VolumeBarGraphic.MoveWindow(CRect(cx-30, 0, cx, 90));
  if (m_Blank.m_hWnd != NULL)
    m_Blank.MoveWindow(CRect(cx-50, 90, cx, cy));

  if (m_MusicTrackBar.m_hWnd != NULL)
    m_MusicTrackBar.MoveWindow(CRect(0, cy-30, cx-50, cy));

  CDocumentWindow::OnSize(type, cx, cy);
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CMusicWindow::OnTimer(UINT timerID)
{
  //I hope this saves more cpu than it is used for figuring it out...

  if (m_Module.IsPlaying())
  {
    if (m_PlayButton.IsWindowEnabled())
    {
      m_PlayButton.EnableWindow(FALSE);
      m_StopButton.EnableWindow(TRUE);
    }

    //sets the music track bar to the current position...
    if (!m_MusicTrackBar.MouseDown)
      if (m_MusicTrackBar.GetPos() != (int)m_Module.GetSongPos())
        m_MusicTrackBar.SetPos(m_Module.GetSongPos());
    
  }
  else
  {
    if (!m_PlayButton.IsWindowEnabled())
    {
      m_PlayButton.EnableWindow(TRUE);
      m_StopButton.EnableWindow(FALSE);
    }
  }
  
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CMusicWindow::OnHScroll(UINT code, UINT pos, CScrollBar *scroll_bar)
{
  if (!m_MusicTrackBar.MouseDown)
    m_Module.SetSongPos(m_MusicTrackBar.GetPos());
  
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CMusicWindow::OnVScroll(UINT code, UINT pos, CScrollBar *scroll_bar)
{
  m_Module.SetVolume(65535 - m_VolumeBar.GetPos());
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CMusicWindow::OnMusicPlay()
{
  // ignore this if the user managed to hit the play button while it was playing
  if (m_Module.IsPlaying())
    return;

  if (!m_Module.Play())
    MessageBox("Error: Could not play music");
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CMusicWindow::OnMusicStop()
{
  m_Module.Stop();
  //m_MusicTrackBar.SetPos(0);
}

////////////////////////////////////////////////////////////////////////////////
