#ifndef MAP_VIEW_HPP
#define MAP_VIEW_HPP


#include <afxwin.h>
#include <afxext.h>
#include "../common/Map.hpp"
#include "../common/Tileset.hpp"
#include "DIBSection.hpp"


class CMapViewHandler
{
public:
  virtual void MV_MapChanged() = 0;
  virtual void MV_SelectedTileChanged(int tile) = 0;
};


class CMapView : public CWnd
{
public:
  CMapView();
  ~CMapView();

  BOOL Create(CStatusBar* status_bar, CMapViewHandler* handler, CWnd* parent, sMap* map);

  void SetZoomSize(int size);
  int  GetZoomSize();

  void TilesetChanged();

  void SelectTile(int tile);
  void SelectLayer(int layer);

  void UpdateScrollBars();

private:
  int GetPageSizeX();
  int GetPageSizeY();
  int GetTotalTilesX();
  int GetTotalTilesY();
  void ValidateScrollValues();
  
  void Click(int x, int y);
  void SelectTileUnderPoint(CPoint point);

  void DrawTile(CDC& dc, const RECT& rect, int tx, int ty);

  afx_msg void OnPaint();
  afx_msg void OnSize(UINT type, int cx, int cy);
  afx_msg void OnHScroll(UINT code, UINT pos, CScrollBar* scroll_bar);
  afx_msg void OnVScroll(UINT code, UINT pos, CScrollBar* scroll_bar);
  afx_msg void OnLButtonDown(UINT flags, CPoint point);
  afx_msg void OnMouseMove(UINT flags, CPoint point);
  afx_msg void OnLButtonUp(UINT flags, CPoint point);
  afx_msg void OnRButtonUp(UINT flags, CPoint point);

private:
  CMapViewHandler* m_Handler;
  CStatusBar*      m_StatusBar;

  sMap* m_Map;

  CDIBSection* m_BlitTile;
  int m_ZoomSize;

  int m_CurrentX;
  int m_CurrentY;

  int m_SelectedTile;
  int m_SelectedLayer;

  bool m_Clicked;

  DECLARE_MESSAGE_MAP()
};


#endif
