#include "MapPropertiesDialog.hpp"
#include "../common/Map.hpp"
#include "resource.h"



////////////////////////////////////////////////////////////////////////////////

CMapPropertiesDialog::CMapPropertiesDialog(sMap* map)
: CDialog(IDD_MAPPROPERTIES)
, m_Map(map)
{
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CMapPropertiesDialog::OnInitDialog()
{
  // get music file
  SetDlgItemText(IDC_MUSIC, m_Map->GetMusicFile());

  // set music file
  char script[512];
  strcpy(script, m_Map->GetScriptFile());
  if (strrchr(script, '.'))
    strcpy(strrchr(script, '.'), ".ss");
  else if (strlen(script) > 0)
    strcat(script, ".ss");
  SetDlgItemText(IDC_SCRIPT, script);

  return TRUE;
}

////////////////////////////////////////////////////////////////////////////////

void
CMapPropertiesDialog::OnOK()
{
  // get music file
  char music[512];
  GetDlgItemText(IDC_MUSIC, music, 500);
  m_Map->SetMusicFile(music);

  // get script file
  char script[512];
  GetDlgItemText(IDC_SCRIPT, script, 500);
  if (strrchr(script, '.'))
    strcpy(strrchr(script, '.'), ".ssx");
  else if (strlen(script) > 0)
    strcat(script, ".ssx");
  m_Map->SetScriptFile(script);
  
  CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////
