#ifndef MAIN_WINDOW_HPP
#define MAIN_WINDOW_HPP


#include <afxwin.h>
#include <afxext.h>
#include <afxtempl.h>
#include "Project.hpp"


class CDocumentWindow;  // DocumentWindow.hpp
class CProjectWindow;   // ProjectWindow.hpp


class CMainWindow : public CMDIFrameWnd
{
public:
  CMainWindow();
  
  BOOL Create();

  void CreateProject(const char* projectname, const char* gametitle);
  void OpenProject(const char* filename);
  void CloseProject();

  void OpenGameSettings();
  void OpenDocumentWindow(EGroupType grouptype, const char* filename);

private:
  bool AddToDirectory(const char* pathname, const char* sub_directory);
  bool CheckDirectory(const char* filename, const char* sub_directory);
  void InsertProjectFile(CFileDialog* file_dialog, EGroupType grouptype);
  void GetGamesDirectory(char games_directory[MAX_PATH]);
  void UpdateMenu();

  afx_msg void OnClose();

  afx_msg void OnFileOpen();

  afx_msg void OnFileNewProject();
  afx_msg void OnFileOpenProject();
  afx_msg void OnFileCloseProject();

  afx_msg void OnFileNewMap();
  afx_msg void OnFileNewSpriteset();
  afx_msg void OnFileNewScript();
  afx_msg void OnFileNewFont();
  afx_msg void OnFileNewWindowStyle();
  afx_msg void OnFileNewImage();
  afx_msg void OnFileNewDoodad();

  afx_msg void OnFileOpenMap();
  afx_msg void OnFileOpenSpriteset();
  afx_msg void OnFileOpenScript();
  afx_msg void OnFileOpenSound();
  afx_msg void OnFileOpenMusic();
  afx_msg void OnFileOpenFont();
  afx_msg void OnFileOpenWindowStyle();
  afx_msg void OnFileOpenImage();
  afx_msg void OnFileOpenAnimation();
  afx_msg void OnFileOpenDoodad();

  afx_msg void OnFileImportImageToMap();
  afx_msg void OnFileImportBitmapToRWS();
  afx_msg void OnFileImportBitmapToRSS();

  afx_msg void OnFileOptions();

  afx_msg void OnProjectInsertMap();
  afx_msg void OnProjectInsertSpriteset();
  afx_msg void OnProjectInsertScript();
  afx_msg void OnProjectInsertSound();
  afx_msg void OnProjectInsertMusic();
  afx_msg void OnProjectInsertFont();
  afx_msg void OnProjectInsertWindowStyle();
  afx_msg void OnProjectInsertImage();
  afx_msg void OnProjectInsertAnimation();
  afx_msg void OnProjectInsertDoodad();

  afx_msg void OnProjectRefresh();
  afx_msg void OnProjectRunSphere();
  afx_msg void OnProjectConfigureSphere();

  afx_msg void OnHelpContents();
  afx_msg void OnHelpAbout();

  afx_msg void OnUpdateProjectCommand(CCmdUI* cmdui);
  afx_msg void OnUpdateSaveCommand(CCmdUI* cmdui);

  afx_msg LRESULT OnDocumentWindowClosing(WPARAM wparam, LPARAM lparam);
  afx_msg LRESULT OnSetChildMenu(WPARAM wparam, LPARAM lparam);
  afx_msg LRESULT OnClearChildMenu(WPARAM wparam, LPARAM lparam);

private:
  CToolBar   m_ToolBar;
  CStatusBar m_StatusBar;

  bool     m_ProjectOpen;
  CProject m_Project;

  CProjectWindow* m_ProjectWindow;

  // manage pointers to document windows so we can enumerate and send messages to them
  CArray<CDocumentWindow*, CDocumentWindow*> m_DocumentWindows;

  int m_ChildMenuResource;

  DECLARE_MESSAGE_MAP()
};


#endif
