#include "GameSettingsDialog.hpp"
#include "Project.hpp"
#include "resource.h"


////////////////////////////////////////////////////////////////////////////////

CGameSettingsDialog::CGameSettingsDialog(CProject* pProject)
: CDialog(IDD_GAMESETTINGS)
, m_pProject(pProject)
, m_pGameTitleEdit(NULL)
, m_pScriptsList(NULL)
{
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CGameSettingsDialog::OnInitDialog()
{
  // get dialog controls
  m_pGameTitleEdit = (CEdit*)GetDlgItem(IDC_GAMETITLE);
  m_pScriptsList   = (CComboBox*)GetDlgItem(IDC_SCRIPT);

  // set game title
  m_pGameTitleEdit->SetFocus();
  m_pGameTitleEdit->SetWindowText(m_pProject->GetGameTitle());
  m_pGameTitleEdit->SetSel(0, -1);

  // fill script list
  if (m_pProject->GetItemCount(GT_SCRIPTS) > 0)
  {
    // add the scripts from the project
    for (int i = 0; i < m_pProject->GetItemCount(GT_SCRIPTS); i++)
    {
      char szScript[MAX_PATH];
      strcpy(szScript, m_pProject->GetItem(GT_SCRIPTS, i));
      m_pScriptsList->AddString(szScript);
    }

    const char* game_script = m_pProject->GetGameScript();
    m_pScriptsList->SelectString(-1, game_script);
  }
  else
  {
    m_pScriptsList->AddString("(none)");

    // select the only item in the script list
    m_pScriptsList->SetCurSel(0);
  }

  // set screen resolution
  SetDlgItemInt(IDC_SCREENWIDTH,  m_pProject->GetScreenWidth());
  SetDlgItemInt(IDC_SCREENHEIGHT, m_pProject->GetScreenHeight());

  return FALSE;
}

////////////////////////////////////////////////////////////////////////////////

void
CGameSettingsDialog::OnOK()
{
  int screen_width  = GetDlgItemInt(IDC_SCREENWIDTH);
  int screen_height = GetDlgItemInt(IDC_SCREENHEIGHT);

  if (screen_width < 1 || screen_width > 2048)
  {
    MessageBox("Screen width must be between 1 and 2048", "Game Settings");
    return;
  }

  if (screen_height < 1 || screen_height > 1536)
  {
    MessageBox("Screen height must be between 1 and 1536", "Game Settings");
    return;
  }

  CString sGameTitle;
  m_pGameTitleEdit->GetWindowText(sGameTitle);
  m_pProject->SetGameTitle(sGameTitle);
  
  // if the project contains any scripts, set it to the one that's selected
  if (m_pProject->GetItemCount(GT_SCRIPTS) > 0)
  {
    CString game_script;
    m_pScriptsList->GetLBText(m_pScriptsList->GetCurSel(), game_script);
    m_pProject->SetGameScript(game_script);
  }

  m_pProject->SetScreenWidth(screen_width);
  m_pProject->SetScreenHeight(screen_height);

  m_pProject->Save();

  CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////
