#include <windows.h>
#include <stdio.h>
#include "FileSystem.hpp"


////////////////////////////////////////////////////////////////////////////////

bool PathExists(const char* szPath)
{
  char szOldDirectory[MAX_PATH];
  GetCurrentDirectory(MAX_PATH, szOldDirectory);

  BOOL bRetVal = SetCurrentDirectory(szPath);

  SetCurrentDirectory(szOldDirectory);
  return (bRetVal ? true : false);
}

////////////////////////////////////////////////////////////////////////////////

bool FileExists(const char* szFile)
{
  HANDLE hFile = CreateFile(
    szFile, 
    0,
    FILE_SHARE_READ | FILE_SHARE_WRITE,
    NULL,
    OPEN_EXISTING,
    0,
    NULL);
  if (hFile == INVALID_HANDLE_VALUE)
    return false;

  CloseHandle(hFile);
  return true;    
}

////////////////////////////////////////////////////////////////////////////////

int FileSize(const char* filename)
{
  FILE* file = fopen(filename, "rb");
  if (file == NULL)
    return -1;
  fseek(file, 0, SEEK_END);
  int size = ftell(file);
  fclose(file);
  return size;
}

////////////////////////////////////////////////////////////////////////////////
