#include "FileDialogs.hpp"


#define DEFINE_FILE_DIALOG_CONSTRUCTOR(name, default_ext, filter)                      \
name::name(EFileDialogMode Mode, bool bMustExist, bool bMultiSelectnOverWritePrompt)                                      \
: CFileDialog(Mode == FDM_OPEN,                                                        \
              default_ext,                                                             \
              NULL,                                                                    \
              (bMultiSelectnOverWritePrompt ? OFN_ALLOWMULTISELECT : OFN_OVERWRITEPROMPT) | OFN_HIDEREADONLY | (bMustExist ? OFN_FILEMUSTEXIST : OFN_PATHMUSTEXIST), \
              (CString(filter) + "All Files (*.*)|*.*||"))                             \
{                                                                                      \
}


DEFINE_FILE_DIALOG_CONSTRUCTOR(CMapFileDialog,         "rmp",  "Sphere Map Files (*.rmp)|*.rmp|")
DEFINE_FILE_DIALOG_CONSTRUCTOR(CTilesetFileDialog,     "rts",  "Sphere Tileset Files (*.rts)|*.rts|")
DEFINE_FILE_DIALOG_CONSTRUCTOR(CSpritesetFileDialog,   "rss",  "Sphere Spriteset Files (*.rss)|*.rss|")
DEFINE_FILE_DIALOG_CONSTRUCTOR(CMusicFileDialog,       "midi", "All Music (*.midi,*.mid,*.it,*.xm,*.s3m,*.mod,*.mp3,*.wav)|*.midi;*.mid;*.it;*.xm;*.s3m;*.mod;*.mp3;*.wav|"  \
                                                               "MIDI Files (*.midi,*.mid)|*.midi;*.mid|" \
                                                               "Impulse Tracker Files (*.it)|*.it|"      \
                                                               "FastTracker 2 Files (*.xm)|*.xm|"        \
                                                               "ScreamTracker 3 Files (*.s3m)|*.s3m|"    \
                                                               "Amiga Mod Files Files (*.mod)|*.mod|"    \
                                                               "MPEG 1 Layer 3 Files (*.mp3)|*.mp3|"     \
                                                               "Waveform Audio Files (*.wav)|*.wav|")
DEFINE_FILE_DIALOG_CONSTRUCTOR(CSoundFileDialog,       "wav",  "All Sounds (*.wav, *.raw)|*.wav;*.raw|"  \
                                                               "Waveform Audio Files (*.wav)|*.wav|"     \
                                                               "RAW Files (*.raw)|*.raw|")
DEFINE_FILE_DIALOG_CONSTRUCTOR(CScriptFileDialog,      "ss",   "SphereScript Files (*.ss, *.ssl)|*.ss;*.ssl|")
DEFINE_FILE_DIALOG_CONSTRUCTOR(CImageFileDialog,       "png",  "All Images (*.png,*.bmp,*.pcx)|*.png;*.bmp;*.pcx|" \
                                                               "PNG Images (*.png)|*.png|"                         \
                                                               "Bitmap Images (*.bmp)|*.bmp|"                      \
                                                               "PCX Images (*.pcx)|*.pcx|")
DEFINE_FILE_DIALOG_CONSTRUCTOR(CAnimationFileDialog,   "flic", "Autodesk Animation (*.flic,*.flc,*.fli)|*.flic;*.flc;*.fli|")
DEFINE_FILE_DIALOG_CONSTRUCTOR(CWindowStyleFileDialog, "rws",  "Sphere Window Style File (*.rws)|*.rws|")
DEFINE_FILE_DIALOG_CONSTRUCTOR(CFontFileDialog,        "rfn",  "Sphere Font File (*.rfn)|*.rfn|")
DEFINE_FILE_DIALOG_CONSTRUCTOR(CDoodadFileDialog,      "rdd",  "Sphere Doodad File (*.rdd)|*.rdd|")
DEFINE_FILE_DIALOG_CONSTRUCTOR(CImportFileDialog,      "bmp",  "All Pictures (*.bmp,*.png,*.dib,*.pcx)|*.bmp;*.pcx|" \
                                                               "PNG Pictures (*.png)|*.png|"                         \
                                                               "BMP Pictures (*.bmp,*.dib)|*.bmp;*.dib|"             \
                                                               "PCX Pictures (*.pcx)|*.pcx|")
