#include "EntityWarpDialog.hpp"
#include "resource.h"


BEGIN_MESSAGE_MAP(CEntityWarpDialog, CDialog)

  ON_BN_CLICKED(IDC_DESTINATION, OnUseDestination)

END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////////

CEntityWarpDialog::CEntityWarpDialog(sWarpEntity& warp, const sTileset& tileset)
: CDialog(IDD_ENTITY_WARP)
, m_Warp(warp)
, m_Tileset(tileset)
{
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CEntityWarpDialog::OnInitDialog()
{
  SetDlgItemText(IDC_MAP,  m_Warp.GetDestinationMap());
  SetDlgItemInt(IDC_FADE,  m_Warp.GetFade());

  bool use_destination = (m_Warp.GetDestinationX() != -1);
  if (use_destination)
    CheckDlgButton(IDC_DESTINATION, BST_CHECKED);
  else
    m_Warp.SetDestination(0, 0, 0);

  SetDlgItemInt(IDC_X,     m_Warp.GetDestinationX() / m_Tileset.GetTileWidth());
  SetDlgItemInt(IDC_Y,     m_Warp.GetDestinationY() / m_Tileset.GetTileHeight());
  SetDlgItemInt(IDC_LAYER, m_Warp.GetDestinationLayer());

  OnUseDestination();

  GetDlgItem(IDC_MAP)->SetFocus();
  return FALSE;
}

////////////////////////////////////////////////////////////////////////////////

void
CEntityWarpDialog::OnOK()
{
  char map[520];
  GetDlgItemText(IDC_MAP, map, 500);
  m_Warp.SetDestinationMap(map);
  m_Warp.SetFade(GetDlgItemInt(IDC_FADE));

  if (IsDlgButtonChecked(IDC_DESTINATION))
  {
    int px = GetDlgItemInt(IDC_X) * m_Tileset.GetTileWidth();
    int py = GetDlgItemInt(IDC_Y) * m_Tileset.GetTileHeight();
    m_Warp.SetDestination(px, py, GetDlgItemInt(IDC_LAYER));
  }
  else
    m_Warp.SetDestination(-1, -1, -1);
  
  CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CEntityWarpDialog::OnUseDestination()
{
  BOOL enable;
  if (IsDlgButtonChecked(IDC_DESTINATION))
    enable = TRUE;
  else
    enable = FALSE;

  GetDlgItem(IDC_X)->EnableWindow(enable);
  GetDlgItem(IDC_Y)->EnableWindow(enable);
  GetDlgItem(IDC_LAYER)->EnableWindow(enable);
}

////////////////////////////////////////////////////////////////////////////////
