#include "EntityDoodadDialog.hpp"
#include "resource.h"


////////////////////////////////////////////////////////////////////////////////

CEntityDoodadDialog::CEntityDoodadDialog(sDoodadEntity& doodad)
: CDialog(IDD_ENTITY_DOODAD)
, m_Doodad(doodad)
{
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CEntityDoodadDialog::OnInitDialog()
{
  SendDlgItemMessage(IDC_ACTIVATION_METHOD, CB_ADDSTRING, 0, (LPARAM)"None");
  SendDlgItemMessage(IDC_ACTIVATION_METHOD, CB_ADDSTRING, 0, (LPARAM)"Door-style");
  SendDlgItemMessage(IDC_ACTIVATION_METHOD, CB_ADDSTRING, 0, (LPARAM)"Chest-style");

  SetDlgItemText(IDC_FILE, m_Doodad.GetSpritesetFile());
  SetDlgItemText(IDC_FUNCTION, m_Doodad.GetFunction());
  CheckDlgButton(IDC_OBSTRUCTIVE, m_Doodad.IsObstructive() ? BST_CHECKED : BST_UNCHECKED);
  SendDlgItemMessage(IDC_ACTIVATION_METHOD, CB_SETCURSEL, m_Doodad.GetActivationMethod());

  GetDlgItem(IDC_FILE)->SetFocus();
  return FALSE;
}

////////////////////////////////////////////////////////////////////////////////

void
CEntityDoodadDialog::OnOK()
{
  char doodad_file[MAX_PATH];
  GetDlgItemText(IDC_FILE, doodad_file, MAX_PATH);
  m_Doodad.SetSpritesetFile(doodad_file);

  char function[512];
  GetDlgItemText(IDC_FUNCTION, function, 500);
  m_Doodad.SetFunction(function);

  m_Doodad.SetObstructive(IsDlgButtonChecked(IDC_OBSTRUCTIVE) == BST_CHECKED);
  m_Doodad.SetActivationMethod(SendDlgItemMessage(IDC_ACTIVATION_METHOD, CB_GETCURSEL));

  CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////
