#ifndef COLOR_VIEW_HPP
#define COLOR_VIEW_HPP


#include <afxwin.h>
#include "colorspace.h"


class CColorViewHandler
{
public:
  virtual void CV_ColorChanged(RGB color) = 0;
};


class CColorView : public CWnd
{
public:
  CColorView();
  ~CColorView();

  BOOL Create(CColorViewHandler* pHandler, CWnd* pParentWindow, RGB Color = rgbBlack);

  void SetColor(RGB color);
  RGB  GetColor() const;

private:
  afx_msg void OnPaint();
  afx_msg void OnLButtonDown(UINT flags, CPoint point);

private:
  CColorViewHandler* m_pHandler;

  RGB m_Color;

  DECLARE_MESSAGE_MAP()
};


#endif
