#ifndef WINDOW_STYLE_HPP
#define WINDOW_STYLE_HPP


#include <stdio.h>
#include "Image32.hpp"


class sWindowStyle
{
public:
  enum EBitmap {
    UPPER_LEFT  = 0,
    TOP         = 1,
    UPPER_RIGHT = 2,
    RIGHT       = 3,
    LOWER_RIGHT = 4,
    BOTTOM      = 5,
    LOWER_LEFT  = 6,
    LEFT        = 7,
    BACKGROUND  = 8,
  };

public:
  sWindowStyle();
  ~sWindowStyle();

  void Create(int width, int height);

  bool Load(const char* filename);
  bool Save(const char* filename) const;
  bool Import(const char* filename, RGBA transColor);

  // bitmap functions (corners and edges)
  CImage32&       GetBitmap(int bitmap);
  const CImage32& GetBitmap(int bitmap) const;

private:
  static void WriteBitmap(FILE* file, const CImage32* bitmap);
  static void ReadBitmap(FILE* file, CImage32* bitmap);
  static void ReadBitmap(FILE* file, CImage32* bitmap, int edge_width);

private:
  CImage32 m_Bitmaps[9];
};


inline CImage32&
sWindowStyle::GetBitmap(int bitmap)
{
  return m_Bitmaps[bitmap];
}


inline const CImage32&
sWindowStyle::GetBitmap(int bitmap) const
{
  return m_Bitmaps[bitmap];
}


#endif
