#ifndef TILE_HPP
#define TILE_HPP


#include "Image32.hpp"


class sTile : public CImage32
{
public:
  sTile(int width = 16, int height = 16);
  sTile(const sTile& rhs);
  ~sTile();

  sTile& operator=(const sTile& rhs);

  bool IsAnimated() const;
  int  GetNextTile() const;
  int  GetDelay() const;
  bool IsReflective() const;
  bool IsObstructed(int x, int y) const;

  void SetAnimated(bool animated);
  void SetNextTile(int next_tile);
  void SetDelay(int delay);
  void SetReflective(bool reflective);
  void SetObstructed(int x, int y, bool obstructed);

private:
  virtual void OnResize(int old_width, int old_height);

private:
  bool m_Animated;
  int  m_NextTile;
  int  m_Delay;
  bool m_Reflective;

  bool* m_Obstructions;
};


inline bool
sTile::IsAnimated() const
{
  return m_Animated;
}


inline int
sTile::GetNextTile() const
{
  return m_NextTile;
}


inline int
sTile::GetDelay() const
{
  return m_Delay;
}


inline bool
sTile::IsReflective() const
{
  return m_Reflective;
}


inline bool
sTile::IsObstructed(int x, int y) const
{
  return m_Obstructions[y * GetWidth() + x];
}


#endif
