#include <string.h>
#include "Tile.hpp"
#include "x++.hpp"


////////////////////////////////////////////////////////////////////////////////

sTile::sTile(int width, int height)
: CImage32(width, height)
, m_Animated(false)
, m_NextTile(0)
, m_Delay(0)
, m_Reflective(false)
, m_Obstructions(NULL)
{
  m_Obstructions = new bool[width * height];
  for (int i = 0; i < width * height; i++)
    m_Obstructions[i] = false;

  Clear();
}

////////////////////////////////////////////////////////////////////////////////

sTile::sTile(const sTile& rhs)
: CImage32(rhs.GetWidth(), rhs.GetHeight())
{
  m_Animated   = rhs.m_Animated;
  m_NextTile   = rhs.m_NextTile;
  m_Delay      = rhs.m_Delay;
  m_Reflective = rhs.m_Reflective;

  m_Obstructions = new bool[rhs.GetWidth() * rhs.GetHeight()];
  for (int i = 0; i < rhs.GetWidth() * rhs.GetHeight(); i++)
    m_Obstructions[i] = rhs.m_Obstructions[i];
}

////////////////////////////////////////////////////////////////////////////////

sTile::~sTile()
{
  delete[] m_Obstructions;
}

////////////////////////////////////////////////////////////////////////////////

sTile&
sTile::operator=(const sTile& rhs)
{
  CImage32::operator=(rhs);

  delete[] m_Obstructions;

  m_Animated   = rhs.m_Animated;
  m_NextTile   = rhs.m_NextTile;
  m_Delay      = rhs.m_Delay;
  m_Reflective = rhs.m_Reflective;

  m_Obstructions = new bool[rhs.GetWidth() * rhs.GetHeight()];
  for (int i = 0; i < rhs.GetWidth() * rhs.GetHeight(); i++)
    m_Obstructions[i] = rhs.m_Obstructions[i];
  return *this;
}

////////////////////////////////////////////////////////////////////////////////

void
sTile::SetAnimated(bool animated)
{
  m_Animated = animated;
}

////////////////////////////////////////////////////////////////////////////////

void
sTile::SetNextTile(int next_tile)
{
  m_NextTile = next_tile;
}

////////////////////////////////////////////////////////////////////////////////

void
sTile::SetDelay(int delay)
{
  m_Delay = delay;
}

////////////////////////////////////////////////////////////////////////////////

void
sTile::SetReflective(bool reflective)
{
  m_Reflective = reflective;
}

////////////////////////////////////////////////////////////////////////////////

void
sTile::SetObstructed(int x, int y, bool obstructed)
{
  m_Obstructions[y * GetWidth() + x] = obstructed;
}

////////////////////////////////////////////////////////////////////////////////

void
sTile::OnResize(int old_width, int old_height)
{
  // reallocate the obstruction table
  bool* new_obstructions = new bool[GetWidth() * GetHeight()];

  for (int iy = 0; iy < GetHeight(); iy++)
    for (int ix = 0; ix < GetWidth(); ix++)
      if (ix < old_width && iy < old_height)
        new_obstructions[iy * GetWidth() + ix] = m_Obstructions[iy * old_width + ix];
      else
        new_obstructions[iy * GetWidth() + ix] = false;

  delete[] m_Obstructions;
  m_Obstructions = new_obstructions;
}

////////////////////////////////////////////////////////////////////////////////
