#ifndef SPRITESET_HPP
#define SPRITESET_HPP


#include <stdio.h>
#include "Sprite.hpp"


class sSpriteset
{
public:
  enum DirectionValue {
    NORTH = 0,
    NORTHEAST = 1,
    EAST = 2,
    SOUTHEAST = 3,
    SOUTH = 4,
    SOUTHWEST = 5,
    WEST = 6,
    NORTHWEST = 7
  };

public:
  sSpriteset();
  ~sSpriteset();

  void Create(int num_directions = 8, int num_frames = 8);
  bool Load(const char* filename);
  bool Save(const char* filename) const;

  bool Import_BMP(const char* filename, int frame_width, int frame_height, RGBA transColor);
  bool Import_CHR(const char* filename, const char* palette_file);

  int GetFrameWidth() const;
  int GetFrameHeight() const;
  void ResizeFrames(int width, int height);

  void InsertDirection(int direction);
  void DeleteDirection(int direction);
  void AppendDirection();

  void InsertFrame(int direction, int frame);
  void DeleteFrame(int direction, int frame);
  void AppendFrame(int direction);

  int      GetNumDirections() const;
  int      GetNumFrames(int direction) const;
  sSprite& GetFrame(int direction, int frame);
  const sSprite& GetFrame(int direction, int frame) const;

  int GetBaseX1() const;
  int GetBaseY1() const;
  int GetBaseX2() const;
  int GetBaseY2() const;
  
  void SetBaseX1(int x);
  void SetBaseY1(int y);
  void SetBaseX2(int x);
  void SetBaseY2(int y);

private:
  struct Direction
  {
    int      num_frames;
    sSprite* frames;
  };

private:
  void Destroy();

  bool Import_CHR1(FILE* file, RGB palette[256]);
  bool Import_CHR2(FILE* file, RGB palette[256]);

private:
  int m_FrameWidth;
  int m_FrameHeight;

  int        m_NumDirections;
  Direction* m_Directions;

  int m_BaseX1;
  int m_BaseY1;
  int m_BaseX2;
  int m_BaseY2;
};


#endif
