// Sphere Data Types
// Replacements for STL types, because VC++'s C++ implementation *sucks*


#ifndef STYPES_HPP
#define STYPES_HPP


#include <string.h>
#include "x++.hpp"


/******************************************************************************/

class sString
{
public:
  sString(const char* str = "")
  : m_str(newstr(str))
  {
  }

  //////////////////////////////////////////////////////////////////////////////

  sString(char c)
  : m_str(new char[2])
  {
    m_str[0] = c;
    m_str[1] = 0;
  }

  //////////////////////////////////////////////////////////////////////////////

  sString(const sString& rhs)
  : m_str(newstr(rhs.m_str))
  {
  }

  //////////////////////////////////////////////////////////////////////////////

  ~sString()
  {
    delete[] m_str;
  }

  //////////////////////////////////////////////////////////////////////////////

  sString& operator=(const sString& rhs)
  {
    delete[] m_str;
    m_str = newstr(rhs.m_str);
    return *this;
  }

  //////////////////////////////////////////////////////////////////////////////

  char& operator[](int i)
  {
    return m_str[i];
  }

  //////////////////////////////////////////////////////////////////////////////

  const char operator[](int i) const
  {
    return m_str[i];
  }

  //////////////////////////////////////////////////////////////////////////////

  const char* c_str() const
  {
    return m_str;
  }

  //////////////////////////////////////////////////////////////////////////////

  int length() const
  {
    return strlen(m_str);
  }

private:
  char* m_str;
};

inline bool operator==(const sString& lhs, const sString& rhs)
{
  return strcmp(lhs.c_str(), rhs.c_str()) == 0;
}

inline bool operator!=(const sString& lhs, const sString& rhs)
{
  return !(lhs == rhs);
}

inline sString& operator+=(sString& lhs, const sString& rhs)
{
  char* new_string = new char[strlen(lhs.c_str()) + strlen(rhs.c_str()) + 1];
  strcpy(new_string, lhs.c_str());
  strcat(new_string, rhs.c_str());
  lhs = new_string;
  delete[] new_string;
  return lhs;
}

inline sString operator+(const sString& lhs, const sString& rhs)
{
  sString s(lhs);
  s += rhs;
  return s;
}

/******************************************************************************/

template<typename T>
class sVector
{
public:
  sVector()
  : m_allocated(0)
  , m_size(0)
  , m_elements(NULL)
  {
  }

  //////////////////////////////////////////////////////////////////////////////

  sVector(const sVector& rhs)
  {
    m_allocated = (rhs.m_size);
    m_size = (rhs.m_size);
    m_elements = (duplicate(rhs.m_elements, rhs.m_size));
  }

  //////////////////////////////////////////////////////////////////////////////

  ~sVector()
  {
    delete[] m_elements;
  }

  //////////////////////////////////////////////////////////////////////////////

  sVector& operator=(const sVector& rhs)
  {
    delete[] m_elements;
    m_allocated = rhs.m_size;
    m_size      = rhs.m_size;
    m_elements  = duplicate(rhs.m_elements, rhs.m_size);
    return *this;
  }

  //////////////////////////////////////////////////////////////////////////////

  T& operator[](int i)
  {
    return m_elements[i];
  }

  //////////////////////////////////////////////////////////////////////////////

  T operator[](int i) const
  {
    return m_elements[i];
  }

  //////////////////////////////////////////////////////////////////////////////

  void clear()
  {
    m_size = 0;
  }

  //////////////////////////////////////////////////////////////////////////////

  void push_back(T item)
  {
    const int ALLOCATE = 64;
    m_size++;
    if (m_size > m_allocated)
    {
      resize(m_elements, m_allocated, m_allocated + ALLOCATE);
      m_allocated += ALLOCATE;
    }
    m_elements[m_size - 1] = item;
  }

  //////////////////////////////////////////////////////////////////////////////

  void pop_back()
  {
    m_size--;
  }

  //////////////////////////////////////////////////////////////////////////////

  void remove(int i)
  {
    m_size--;
    for (int j = i; j < m_size; j++)
      m_elements[j] = m_elements[j + 1];
  }

  //////////////////////////////////////////////////////////////////////////////

  int size() const
  {
    return m_size;
  }

private:
  int m_allocated;
  int m_size;
  T*  m_elements;

  friend bool operator==(const sVector& lhs, const sVector& rhs);
};


template<typename T>
bool operator==(const sVector<T>& lhs, const sVector<T>& rhs)
{
  if (lhs.m_size != rhs.m_size)
    return false;
  for (int i = 0; i < lhs.m_size; i++)
    if (lhs.m_elements[i] != rhs.m_elements[i])
      return false;
  return true;
}


template<typename T>
bool operator!=(const sVector<T>& lhs, const sVector<T>& rhs)
{
  return !(lhs == rhs);
}


/******************************************************************************/

template<typename T>
class sStack
{
private:
  struct Node
  {
    T element;
    Node* next;
  };

public:
  sStack()
  : m_head(NULL)
  , m_size(0)
  {
  }

  //////////////////////////////////////////////////////////////////////////////

  ~sStack()
  {
    Node* p = m_head;
    while (p) {
      Node* q = p;
      p = p->next;
      delete q;
    }
  }

  //////////////////////////////////////////////////////////////////////////////

  void push(const T& t)
  {
    m_size++;
    Node* p = new Node;
    p->element = t;
    p->next = m_head;
    m_head = p;
  }

  //////////////////////////////////////////////////////////////////////////////

  void pop()
  {
    m_size--;
    Node* q = m_head;
    m_head = q->next;
    delete q;
  }

  //////////////////////////////////////////////////////////////////////////////

  T& top()
  {
    return m_head->element;
  }

  //////////////////////////////////////////////////////////////////////////////

  const T& top() const
  {
    return m_head->element;
  }

  //////////////////////////////////////////////////////////////////////////////

  bool empty() const
  {
    return (m_size == 0);
  }

  //////////////////////////////////////////////////////////////////////////////

private:
  Node* m_head;
  int   m_size;
};

/******************************************************************************/


#endif
