#ifndef SS_TYPES_HPP
#define SS_TYPES_HPP


#include "STypes.hpp"


typedef int ssType;
#define TYPE_NONE   0x0000
#define TYPE_VOID   0x0001
#define TYPE_INT    0x0002
#define TYPE_BOOL   0x0003
#define TYPE_STRING 0x0004
#define TYPE_FLOAT  0x0005
#define TYPE_USER   0x0006  // if TYPE_USER <= type < TYPE_ARRAY, user type
#define TYPE_ARRAY  0x1000  // if TYPE_ARRAY <= type, array type

/******************************************************************************/

struct sVariable
{
  sString name;
  ssType  data_type;
};

/******************************************************************************/

struct sUserType
{
  sString            name;
  sVector<sVariable> fields;
};

/******************************************************************************/

struct sFunction
{
  sString         name;
  ssType          return_type;
  sVector<ssType> parameters;

  bool operator==(const sFunction& rhs)
  {
    return (name == rhs.name &&
            return_type == rhs.return_type &&
            parameters == rhs.parameters);
  }

  bool operator!=(const sFunction& lhs)
  {
    return !(*this == lhs);
  }
};

/******************************************************************************/


#endif
