#ifndef SS_TABLES_HPP
#define SS_TABLES_HPP


#include "types.h"
#include "SS_Types.hpp"


// system types
extern const struct SS_SYSTEM_TYPE
{
  const char* name;
  const char* field_list;
} g_SystemTypes[];
extern const int g_NumSystemTypes;


// system functions
extern const struct SS_SYSTEM_FUNCTION
{
  int         ordinal;
  const char* name; 
  ssType      return_type;
  const char* parameter_list;
} g_SystemFunctions[];
extern const int g_NumSystemFunctions;


// system constants
extern const struct SS_SYSTEM_CONSTANTS
{
  const char* name;
  const char* value;
} g_SystemConstants[];
extern const int g_NumSystemConstants;


#define VP_REGISTER  0x0001
#define VP_LITERAL   0x0002
#define VP_LABEL     0x0004
#define VP_LOCAL     0x0008
#define VP_PARAMETER 0x0010

#define VP_REFERENCE 0x8000

#define VP_LVALUE  (VP_REGISTER | VP_LABEL | VP_LOCAL | VP_PARAMETER)
#define VP_RVALUE  (VP_LVALUE | VP_LITERAL)
#define VP_SRVALUE (VP_LVALUE) // string l-value


// VM opcodes
extern const struct SS_OPCODE
{
  char* name;
  int   num_parameters;
  dword raw_value;
  dword parameter1_mask;
  dword parameter2_mask;
} g_Opcodes[];
extern const int g_NumOpcodes;


#endif
