#ifndef SS_ASSEMBLER_HPP
#define SS_ASSEMBLER_HPP


#include "SS_Tables.hpp"
#include "SS_Internal.hpp"


class CBuffer;  // #include "Buffer.hpp"


class sAssembler
{
public:
  sAssembler();
  ~sAssembler();
  
  void Execute(CBuffer* in, CBuffer* out);

private:
  struct Label
  {
    Label()
    { }

    Label(const sString& s, dword l)
    : name(s), location(l)
    { }

    sString name;
    dword   location;
  };

private:
  void FirstPass();
  void SecondPass();
  
  bool ReadLine(sString& line);
  void Tokenize(const sString& line, sVector<sString>& tokens);

  void VerifyNumParameters(const sVector<sString>& tokens, const SS_OPCODE* opcode);
  
  const SS_OPCODE* GetOpcode(const char* s);
  static int       GetOperandSize(const sString& s);
  sdword           GetOperandType(const sString& s);
  sdword           GetOperandCode(const sString& s);

  static bool IsLiteral(const sString& s);
  bool        IsLabel(const sString& s);
  bool        IsLocal(const sString& s);
  bool        IsParameter(const sString& s);

  sdword aLiteral(const sString& s);

  void AddDependancy(const sString& dependancy);
  void Error(const sString& message);

private:
  enum { NO_PASS, FIRST_PASS, SECOND_PASS } Pass;

  char*    inbuffer;
  int      inbufferlocation;
  int      inbuffersize;
  CBuffer* outbuffer;

  int CurrentLocation;
  int CurrentLine;

  sVector<sString> Dependancies;

  sVector<Label>   StringLiterals;
  sVector<Label>   Globals;
  sVector<Label>   Functions;
  sVector<Label>   Labels;
  sVector<sString> Parameters;
  sVector<sString> Locals;
};


#endif
