#ifndef MAP_HPP
#define MAP_HPP


#include "Layer.hpp"
#include "Tileset.hpp"
#include "Entities.hpp"
class CImage32; // #include "Image32.hpp"


class sMap
{
public:
  sMap();
  sMap(int width, int height, int layers = 1);
  sMap(const char* filename);
  ~sMap();

  bool Load(const char* filename);
  bool Save(const char* filename) const;

  bool Create(int width, int height, int layers = 1);
  bool BuildFromImage(CImage32& image, int tile_width = 16, int tile_height = 16);

  bool Import_VergeMAP(const char* filename, const char* tilesetFilename);

  // accessors

  int GetStartX() const;
  int GetStartY() const;
  int GetStartLayer() const;
  int GetStartDirection() const;

  const char* GetMusicFile() const;
  const char* GetScriptFile() const;

  int           GetNumLayers() const;
  sLayer&       GetLayer(int i);
  const sLayer& GetLayer(int i) const;

  int            GetNumEntities() const;
  sEntity&       GetEntity(int i);
  const sEntity& GetEntity(int i) const;

  sTileset&       GetTileset();
  const sTileset& GetTileset() const;

  // mutators

  void SetStartX(int x);
  void SetStartY(int y);
  void SetStartLayer(int layer);
  void SetStartDirection(int direction);

  void InsertLayer(int where, const sLayer& layer);
  void AppendLayer(const sLayer& layer);
  void DeleteLayer(int where);
  void SwapLayers(int layer1, int layer2);

  void AddEntity(sEntity* entity);
  void DeleteEntity(int index);
  int  FindEntity(int x, int y, int layer);

  void SetMusicFile(const char* music);
  void SetScriptFile(const char* script);

private:
  int m_StartX;
  int m_StartY;
  int m_StartLayer;
  int m_StartDirection;

  char* m_MusicFile;
  char* m_ScriptFile;

  int     m_NumLayers;
  sLayer* m_Layers;

  int       m_NumEntities;
  sEntity** m_Entities;

  sTileset m_Tileset;
};


inline int
sMap::GetNumLayers() const
{
  return m_NumLayers;
}


inline sLayer&
sMap::GetLayer(int i)
{
  return m_Layers[i];
}


inline const sLayer&
sMap::GetLayer(int i) const
{
  return m_Layers[i];
}


inline sTileset&
sMap::GetTileset()
{
  return m_Tileset;
}


inline const sTileset&
sMap::GetTileset() const
{
  return m_Tileset;
}


#endif
