#include "Layer.hpp"
#include "x++.hpp"


////////////////////////////////////////////////////////////////////////////////

sLayer::sLayer()
: m_Name(newstr(""))
, m_Width(0)
, m_Height(0)
, m_Tiles(NULL)
{
}

////////////////////////////////////////////////////////////////////////////////

sLayer::sLayer(int width, int height)
: m_Name(newstr(""))
, m_Width(width)
, m_Height(height)
, m_Tiles(new int[width * height])
{
  for (int i = 0; i < width * height; i++)
    m_Tiles[i] = 0;
}

////////////////////////////////////////////////////////////////////////////////

sLayer::sLayer(const sLayer& layer)
{
  m_Name = newstr(layer.m_Name);

  m_Width  = layer.m_Width;
  m_Height = layer.m_Height;
  m_Tiles  = new int[m_Width * m_Height];
  memcpy(m_Tiles, layer.m_Tiles, m_Width * m_Height * sizeof(int));

  m_ParallaxXMult = layer.m_ParallaxXMult;
  m_ParallaxXDiv  = layer.m_ParallaxXDiv;
  m_ParallaxYMult = layer.m_ParallaxYMult;
  m_ParallaxYDiv  = layer.m_ParallaxYDiv;

  m_ScrollingXMult = layer.m_ScrollingXMult;
  m_ScrollingXDiv  = layer.m_ScrollingXDiv;
  m_ScrollingYMult = layer.m_ScrollingYMult;
  m_ScrollingYDiv  = layer.m_ScrollingYDiv;
}

////////////////////////////////////////////////////////////////////////////////

sLayer::~sLayer()
{
  delete[] m_Name;
  delete[] m_Tiles;
}

////////////////////////////////////////////////////////////////////////////////

const sLayer&
sLayer::operator=(const sLayer& layer)
{
  delete[] m_Name;
  m_Name = newstr(layer.m_Name);

  // delete the old layer
  delete[] m_Tiles;

  // replace it with the new stuff
  m_Width  = layer.m_Width;
  m_Height = layer.m_Height;
  m_Tiles  = new int[m_Width * m_Height];
  memcpy(m_Tiles, layer.m_Tiles, m_Width * m_Height * sizeof(int));

  m_ParallaxXMult = layer.m_ParallaxXMult;
  m_ParallaxXDiv  = layer.m_ParallaxXDiv;
  m_ParallaxYMult = layer.m_ParallaxYMult;
  m_ParallaxYDiv  = layer.m_ParallaxYDiv;

  m_ScrollingXMult = layer.m_ScrollingXMult;
  m_ScrollingXDiv  = layer.m_ScrollingXDiv;
  m_ScrollingYMult = layer.m_ScrollingYMult;
  m_ScrollingYDiv  = layer.m_ScrollingYDiv;

  return *this;
}

////////////////////////////////////////////////////////////////////////////////

void
sLayer::Resize(int width, int height)
{
  int* new_layer = new int[width * height];
  for (int iy = 0; iy < height; iy++)
    for (int ix = 0; ix < width; ix++)
    {
      if (ix < m_Width && iy < m_Height)
        new_layer[iy * width + ix] = m_Tiles[iy * m_Width + ix];
      else
        new_layer[iy * width + ix] = 0;
    }

  m_Width = width;
  m_Height = height;
  delete[] m_Tiles;
  m_Tiles = new_layer;
}

////////////////////////////////////////////////////////////////////////////////

void
sLayer::SetName(const char* name)
{
  delete[] m_Name;
  m_Name = newstr(name);
}

////////////////////////////////////////////////////////////////////////////////

void
sLayer::SetSize(int x, int y)
{
  // allocate a new block
  int* NewTiles = new int[x * y];

  // clear out the new block
  for (int i = 0; i < x * y; i++)
    NewTiles[i] = 0;

  // move the old block into the new one
  int minx = (x < m_Width) ? x : m_Width;
  int miny = (y < m_Height) ? y : m_Height;
  for (int ix = 0; ix < minx; ix++)
    for (int iy = 0; iy < miny; iy++)
      NewTiles[iy * x + ix] = m_Tiles[iy * m_Width + ix];

  // update layer members
  m_Width = x;
  m_Height = y;
  delete[] m_Tiles;
  m_Tiles = NewTiles;
}

////////////////////////////////////////////////////////////////////////////////

void
sLayer::SetParallaxX(int mult, int div)
{
  m_ParallaxXMult = mult;
  m_ParallaxXDiv = div;
}

////////////////////////////////////////////////////////////////////////////////

void
sLayer::SetParallaxY(int mult, int div)
{
  m_ParallaxYMult = mult;
  m_ParallaxYDiv = div;
}

////////////////////////////////////////////////////////////////////////////////

void
sLayer::SetScrollingX(int mult, int div)
{
  m_ScrollingXMult = mult;
  m_ScrollingXDiv = div;
}

////////////////////////////////////////////////////////////////////////////////

void
sLayer::SetScrollingY(int mult, int div)
{
  m_ScrollingYMult = mult;
  m_ScrollingYDiv = div;
}

////////////////////////////////////////////////////////////////////////////////

const char*
sLayer::GetName() const
{
  return m_Name;
}

////////////////////////////////////////////////////////////////////////////////

int
sLayer::GetParallaxXMult() const
{
  return m_ParallaxXMult;
}

////////////////////////////////////////////////////////////////////////////////

int
sLayer::GetParallaxXDiv() const
{
  return m_ParallaxXDiv;
}

////////////////////////////////////////////////////////////////////////////////

int
sLayer::GetParallaxYMult() const
{
  return m_ParallaxYMult;
}

////////////////////////////////////////////////////////////////////////////////

int
sLayer::GetParallaxYDiv() const
{
  return m_ParallaxYDiv;
}

////////////////////////////////////////////////////////////////////////////////

int
sLayer::GetScrollingXMult() const
{
  return m_ScrollingXMult;
}

////////////////////////////////////////////////////////////////////////////////

int
sLayer::GetScrollingXDiv() const
{
  return m_ScrollingXDiv;
}

////////////////////////////////////////////////////////////////////////////////

int
sLayer::GetScrollingYMult() const
{
  return m_ScrollingYMult;
}

////////////////////////////////////////////////////////////////////////////////

int
sLayer::GetScrollingYDiv() const
{
  return m_ScrollingYDiv;
}

////////////////////////////////////////////////////////////////////////////////
