#ifndef FONT_HPP
#define FONT_HPP



#include "types.h"



/******************************************************************************/

class sFontCharacter
{
public:
  sFontCharacter(int width = 0, int height = 0);
  sFontCharacter(const sFontCharacter& character);
  ~sFontCharacter();

  sFontCharacter& operator=(const sFontCharacter& character);

  int  GetWidth() const;
  int  GetHeight() const;
  void Resize(int width, int height);

  byte*       GetPixels();
  const byte* GetPixels() const;

  void SlideLeft();
  void SlideUp();
  void SlideRight();
  void SlideDown();

private:
  int   m_Width;
  int   m_Height;
  byte* m_Pixels;
};

////////////////////////////////////////////////////////////////////////////////

inline int
sFontCharacter::GetWidth() const
{
  return m_Width;
}

////////////////////////////////////////////////////////////////////////////////

inline int
sFontCharacter::GetHeight() const
{
  return m_Height;
}

////////////////////////////////////////////////////////////////////////////////

inline byte*
sFontCharacter::GetPixels()
{
  return m_Pixels;
}

////////////////////////////////////////////////////////////////////////////////

inline const byte*
sFontCharacter::GetPixels() const
{
  return m_Pixels;
}

////////////////////////////////////////////////////////////////////////////////



/******************************************************************************/

class sFont
{
public:
  sFont(int num_characters = 0, int width = 0, int height = 0);
  ~sFont();

  bool Load(const char* filename);
  bool Save(const char* filename) const;

  void                  SetNumCharacters(int num_characters);

  int                   GetNumCharacters() const;
  sFontCharacter&       GetCharacter(int i);
  const sFontCharacter& GetCharacter(int i) const;

private:
  int             m_NumCharacters;
  sFontCharacter* m_Characters;
};

////////////////////////////////////////////////////////////////////////////////

inline int
sFont::GetNumCharacters() const
{
  return m_NumCharacters;
}

////////////////////////////////////////////////////////////////////////////////

inline sFontCharacter&
sFont::GetCharacter(int i)
{
  return m_Characters[i];
}

////////////////////////////////////////////////////////////////////////////////

inline const sFontCharacter&
sFont::GetCharacter(int i) const
{
  return m_Characters[i];
}

////////////////////////////////////////////////////////////////////////////////



#endif
