#ifndef ENTITIES_HPP
#define ENTITIES_HPP


#include "STypes.hpp"


// sEntity
class sEntity
{
public:
  enum EntityType {
    NONE,
    WARP,
    PERSON,
    TRIGGER,
    DOODAD,
  };

public:
  sEntity();
  virtual ~sEntity();

  // accessors
  EntityType GetEntityType() const;
  int GetX() const;  // pixel coordinates
  int GetY() const;  // pixel coordinates
  int GetLayer() const;

  // mutators
  void SetCoordinates(int x, int y, int layer);

protected:
  EntityType m_EntityType;

private:
  int m_X;  // x coordinate (pixel)
  int m_Y;  // y coordinate (pixel)
  int m_Layer;
};


// sWarp
class sWarpEntity : public sEntity
{
public:
  sWarpEntity();
  ~sWarpEntity();

  // accessors
  const char* GetDestinationMap() const;
  int         GetDestinationX() const;
  int         GetDestinationY() const;
  int         GetDestinationLayer() const;
  int         GetFade() const;

  // mutators
  void SetDestinationMap(const char* map);
  void SetDestination(int x, int y, int layer);
  void SetFade(int fade);

private:
  sString m_DestinationMap;
  int     m_DestinationX;
  int     m_DestinationY;
  int     m_DestinationLayer;
  int     m_Fade;
};


// sPerson
class sPersonEntity : public sEntity
{
public:
  enum Direction { DIRECTION_UP, DIRECTION_RIGHT, DIRECTION_DOWN, DIRECTION_LEFT };
  enum DialogueType { DIALOGUE_TEXT, DIALOGUE_FILE };

public:
  sPersonEntity();
  ~sPersonEntity();

  // accessors
  Direction     GetDirection() const;
  const char*   GetSpritesetFile() const;
  DialogueType  GetDialogueType() const;
  const char*   GetDialogue() const;
  int           GetWalkSpeed() const;
  int           GetWalkDuration() const;
  int           GetWalkDelay() const;

  // mutators
  void SetDirection(Direction direction);
  void SetSpritesetFile(const char* spriteset);
  void SetDialogue(DialogueType dialogue_type, const char* dialogue);
  void SetWalkingRate(int speed, int duration, int delay);

private:
  Direction    m_Direction;
  sString      m_SpritesetFile;
  DialogueType m_DialogueType;
  sString      m_Dialogue;
  int          m_WalkSpeed;
  int          m_WalkDuration;
  int          m_WalkDelay;
};


// sTrigger
class sTriggerEntity : public sEntity
{
public:
  sTriggerEntity();
  ~sTriggerEntity();

  // accessors
  const char* GetFunction() const;

  // mutators
  void SetFunction(const char* function);

private:
  sString m_Function;
};


// sDoodad
class sDoodadEntity : public sEntity
{
public:
  enum { NONE = 0, DOOR = 1, CHEST = 2 };

public:
  sDoodadEntity();
  ~sDoodadEntity();

  // accessors
  const char* GetSpritesetFile() const;
  const char* GetFunction() const;
  bool IsObstructive() const;
  int  GetActivationMethod() const;

  // mutators
  void SetSpritesetFile(const char* spriteset_file);
  void SetFunction(const char* function);
  void SetObstructive(bool obstructive);
  void SetActivationMethod(int activation_method);

private:
  sString m_SpritesetFile;
  sString m_Function;
  bool    m_Obstructive;
  int     m_ActivationMethod;
};


#endif
