#include <stdlib.h>
#include "Entities.hpp"
#include "x++.hpp"


/////////////
// sEntity //
/////////////

////////////////////////////////////////////////////////////////////////////////

sEntity::sEntity()
: m_EntityType(NONE)
, m_X(0)
, m_Y(0)
, m_Layer(0)
{
}

////////////////////////////////////////////////////////////////////////////////

sEntity::~sEntity()
{
}

////////////////////////////////////////////////////////////////////////////////

sEntity::EntityType
sEntity::GetEntityType() const
{
  return m_EntityType;
}

////////////////////////////////////////////////////////////////////////////////

int
sEntity::GetX() const
{
  return m_X;
}

////////////////////////////////////////////////////////////////////////////////

int
sEntity::GetY() const
{
  return m_Y;
}

////////////////////////////////////////////////////////////////////////////////

int
sEntity::GetLayer() const
{
  return m_Layer;
}

////////////////////////////////////////////////////////////////////////////////

void
sEntity::SetCoordinates(int x, int y, int layer)
{
  m_X = x;
  m_Y = y;
  m_Layer = layer;
}

////////////////////////////////////////////////////////////////////////////////


/////////////////
// sWarpEntity //
/////////////////

sWarpEntity::sWarpEntity()
: m_DestinationX(0)
, m_DestinationY(0)
, m_DestinationLayer(0)
, m_Fade(0)
{
  m_EntityType = WARP;
}

////////////////////////////////////////////////////////////////////////////////

sWarpEntity::~sWarpEntity()
{
}

////////////////////////////////////////////////////////////////////////////////

const char*
sWarpEntity::GetDestinationMap() const
{
  return m_DestinationMap.c_str();
}

////////////////////////////////////////////////////////////////////////////////

int
sWarpEntity::GetDestinationX() const
{
  return m_DestinationX;
}

////////////////////////////////////////////////////////////////////////////////

int
sWarpEntity::GetDestinationY() const
{
  return m_DestinationY;
}

////////////////////////////////////////////////////////////////////////////////

int
sWarpEntity::GetDestinationLayer() const
{
  return m_DestinationLayer;
}

////////////////////////////////////////////////////////////////////////////////

int
sWarpEntity::GetFade() const
{
  return m_Fade;
}

////////////////////////////////////////////////////////////////////////////////

void
sWarpEntity::SetDestinationMap(const char* map)
{
  m_DestinationMap = map;
}

////////////////////////////////////////////////////////////////////////////////

void
sWarpEntity::SetDestination(int x, int y, int layer)
{
  m_DestinationX = x;
  m_DestinationY = y;
  m_DestinationLayer = layer;
}

////////////////////////////////////////////////////////////////////////////////

void
sWarpEntity::SetFade(int fade)
{
  m_Fade = fade;
}

////////////////////////////////////////////////////////////////////////////////


///////////////////
// sPersonEntity //
///////////////////

////////////////////////////////////////////////////////////////////////////////

sPersonEntity::sPersonEntity()
: m_Direction(DIRECTION_UP)
, m_DialogueType(DIALOGUE_TEXT)
, m_WalkSpeed(0)
, m_WalkDuration(0)
, m_WalkDelay(0)
{
  m_EntityType = PERSON;
}

////////////////////////////////////////////////////////////////////////////////

sPersonEntity::~sPersonEntity()
{
}

////////////////////////////////////////////////////////////////////////////////

sPersonEntity::Direction
sPersonEntity::GetDirection() const
{
  return m_Direction;
}

////////////////////////////////////////////////////////////////////////////////

const char*
sPersonEntity::GetSpritesetFile() const
{
  return m_SpritesetFile.c_str();
}

////////////////////////////////////////////////////////////////////////////////

sPersonEntity::DialogueType
sPersonEntity::GetDialogueType() const
{
  return m_DialogueType;
}

////////////////////////////////////////////////////////////////////////////////

const char*
sPersonEntity::GetDialogue() const
{
  return m_Dialogue.c_str();
}

////////////////////////////////////////////////////////////////////////////////

int
sPersonEntity::GetWalkSpeed() const
{
  return m_WalkSpeed;
}

////////////////////////////////////////////////////////////////////////////////

int
sPersonEntity::GetWalkDuration() const
{
  return m_WalkDuration;
}

////////////////////////////////////////////////////////////////////////////////

int
sPersonEntity::GetWalkDelay() const
{
  return m_WalkDelay;
}

////////////////////////////////////////////////////////////////////////////////

void
sPersonEntity::SetDirection(Direction direction)
{
  m_Direction = direction;
}

////////////////////////////////////////////////////////////////////////////////

void
sPersonEntity::SetSpritesetFile(const char* spriteset)
{
  m_SpritesetFile = spriteset;
}

////////////////////////////////////////////////////////////////////////////////

void
sPersonEntity::SetDialogue(DialogueType dialogue_type, const char* dialogue)
{
  m_DialogueType = dialogue_type;
  m_Dialogue = dialogue;
}

////////////////////////////////////////////////////////////////////////////////

void
sPersonEntity::SetWalkingRate(int speed, int duration, int delay)
{
  m_WalkSpeed = speed;
  m_WalkDuration = duration;
  m_WalkDelay = delay;
}

////////////////////////////////////////////////////////////////////////////////


////////////////////
// sTriggerEntity //
////////////////////

////////////////////////////////////////////////////////////////////////////////

sTriggerEntity::sTriggerEntity()
{
  m_EntityType = TRIGGER;
}

////////////////////////////////////////////////////////////////////////////////

sTriggerEntity::~sTriggerEntity()
{
}

////////////////////////////////////////////////////////////////////////////////

const char*
sTriggerEntity::GetFunction() const
{
  return m_Function.c_str();
}

////////////////////////////////////////////////////////////////////////////////

void
sTriggerEntity::SetFunction(const char* function)
{
  m_Function = function;
}

////////////////////////////////////////////////////////////////////////////////


///////////////////
// sDoodadEntity //
///////////////////

////////////////////////////////////////////////////////////////////////////////

sDoodadEntity::sDoodadEntity()
: m_Obstructive(false)
, m_ActivationMethod(NONE)
{
  m_EntityType = DOODAD;
}

////////////////////////////////////////////////////////////////////////////////

sDoodadEntity::~sDoodadEntity()
{
}

////////////////////////////////////////////////////////////////////////////////

const char*
sDoodadEntity::GetSpritesetFile() const
{
  return m_SpritesetFile.c_str();
}

////////////////////////////////////////////////////////////////////////////////

const char*
sDoodadEntity::GetFunction() const
{
  return m_Function.c_str();
}

////////////////////////////////////////////////////////////////////////////////

bool
sDoodadEntity::IsObstructive() const
{
  return m_Obstructive;
}

////////////////////////////////////////////////////////////////////////////////

int
sDoodadEntity::GetActivationMethod() const
{
  return m_ActivationMethod;
}

////////////////////////////////////////////////////////////////////////////////

void
sDoodadEntity::SetSpritesetFile(const char* spriteset_file)
{
  m_SpritesetFile = spriteset_file;
}

////////////////////////////////////////////////////////////////////////////////

void
sDoodadEntity::SetFunction(const char* function)
{
  m_Function = function;
}

////////////////////////////////////////////////////////////////////////////////

void
sDoodadEntity::SetObstructive(bool obstructive)
{
  m_Obstructive = obstructive;
}

////////////////////////////////////////////////////////////////////////////////

void
sDoodadEntity::SetActivationMethod(int activation_method)
{
  m_ActivationMethod = activation_method;
}

////////////////////////////////////////////////////////////////////////////////
